/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.miningdimension.dimension;

import de.maxhenkel.miningdimension.Main;
import de.maxhenkel.miningdimension.tileentity.TileentityTeleporter;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;

public class MiningDimensionTeleporter
implements ITeleporter {
    private BlockPos pos;

    public MiningDimensionTeleporter(BlockPos pos) {
        this.pos = pos;
    }

    public Entity placeEntity(Entity entity, ServerWorld currentWorld, ServerWorld destWorld, float yaw, Function<Boolean, Entity> repositionEntity) {
        Entity e = repositionEntity.apply(false);
        if (!(e instanceof ServerPlayerEntity)) {
            return e;
        }
        ServerPlayerEntity player = (ServerPlayerEntity)e;
        Chunk chunk = (Chunk)destWorld.func_217349_x(this.pos);
        BlockPos teleporterPos = this.findPortalInChunk(chunk);
        if (teleporterPos == null) {
            teleporterPos = destWorld.func_234923_W_().equals(Main.MINING_DIMENSION) ? this.placeTeleporterMining(destWorld, chunk) : this.placeTeleporterOverworld(destWorld, chunk);
        }
        if (teleporterPos == null) {
            return e;
        }
        player.func_82242_a(0);
        player.func_70634_a((double)teleporterPos.func_177958_n() + 0.5, (double)teleporterPos.func_177956_o() + 1.0, (double)teleporterPos.func_177952_p() + 0.5);
        return e;
    }

    private BlockPos findPortalInChunk(Chunk chunk) {
        for (TileEntity tile : chunk.func_177434_r().values()) {
            BlockPos pos;
            if (!(tile instanceof TileentityTeleporter) || !chunk.func_180495_p((pos = tile.func_174877_v()).func_177984_a()).func_196958_f()) continue;
            return pos;
        }
        return null;
    }

    private BlockPos placeTeleporterMining(ServerWorld world, Chunk chunk) {
        int z;
        int x;
        int y;
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (y = 0; y < 255; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    pos.func_181079_c(x, y, z);
                    if (!chunk.func_180495_p((BlockPos)pos).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(1)).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(2)).func_196958_f()) continue;
                    BlockPos absolutePos = chunk.func_76632_l().func_206849_h().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    world.func_175656_a(absolutePos, Main.TELEPORTER.func_176223_P());
                    return absolutePos;
                }
            }
        }
        for (y = 0; y < 255; ++y) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    BlockPos absolutePos;
                    pos.func_181079_c(x, y, z);
                    if (!this.isAirOrStone(chunk, (BlockPos)pos) || !this.isAirOrStone(chunk, pos.func_177981_b(1)) || !this.isAirOrStone(chunk, pos.func_177981_b(2)) || !this.isReplaceable((World)world, (absolutePos = chunk.func_76632_l().func_206849_h().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())).func_177981_b(3)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.SOUTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.EAST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(1).func_177972_a(Direction.WEST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.NORTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.SOUTH)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.EAST)) || !this.isReplaceable((World)world, absolutePos.func_177981_b(2).func_177972_a(Direction.WEST))) continue;
                    world.func_175656_a(absolutePos, Main.TELEPORTER.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1), Blocks.field_150350_a.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2), Blocks.field_150350_a.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(3), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.NORTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.SOUTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.EAST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(1).func_177972_a(Direction.WEST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.NORTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.SOUTH), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.EAST), Blocks.field_150348_b.func_176223_P());
                    world.func_175656_a(absolutePos.func_177981_b(2).func_177972_a(Direction.WEST), Blocks.field_150348_b.func_176223_P());
                    return absolutePos;
                }
            }
        }
        return null;
    }

    private boolean isAirOrStone(Chunk chunk, BlockPos pos) {
        BlockState state = chunk.func_180495_p(pos);
        return state.func_177230_c().equals(Blocks.field_150348_b) || state.func_196958_f();
    }

    private boolean isReplaceable(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c().equals(Blocks.field_150348_b) || state.func_177230_c().equals(Blocks.field_196650_c) || state.func_177230_c().equals(Blocks.field_196656_g) || state.func_177230_c().equals(Blocks.field_196654_e) || state.func_177230_c().equals(Blocks.field_150346_d) || state.func_177230_c().equals(Blocks.field_150351_n) || state.func_177230_c().equals(Blocks.field_150353_l) || state.func_196958_f();
    }

    private BlockPos placeTeleporterOverworld(ServerWorld world, Chunk chunk) {
        BlockPos.Mutable pos = new BlockPos.Mutable();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = 63; y < 255; ++y) {
                    pos.func_181079_c(x, y, z);
                    if (!chunk.func_180495_p((BlockPos)pos).func_196958_f() || !chunk.func_180495_p(pos.func_177981_b(1)).func_196958_f()) continue;
                    BlockPos absolutePos = chunk.func_76632_l().func_206849_h().func_177982_a(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    world.func_175656_a(absolutePos, Main.TELEPORTER.func_176223_P());
                    return absolutePos;
                }
            }
        }
        return null;
    }
}

