/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.misc.LevelData;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;

public final class Helper {
    public static boolean getBlockEntitiesInArea(LevelAccessor level, BlockPos pos, int radius, Function<BlockEntity, Boolean> consumer) {
        for (int x = pos.m_123341_() - radius >> 4; x <= pos.m_123341_() + radius >> 4; ++x) {
            for (int z = pos.m_123343_() - radius >> 4; z <= pos.m_123343_() + radius >> 4; ++z) {
                ChunkAccess chunk = Helper.getLoadedChunk(level, x, z);
                if (chunk == null) continue;
                for (BlockPos tilePos : chunk.m_5928_()) {
                    if (!(tilePos.m_123331_((Vec3i)pos) <= (double)(radius * radius)) || !consumer.apply(chunk.m_7702_(tilePos)).booleanValue()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void getAuraChunksWithSpotsInArea(Level level, BlockPos pos, int radius, Consumer<AuraChunk> consumer) {
        LevelData data = (LevelData)ILevelData.getLevelData(level);
        for (int x = pos.m_123341_() - radius >> 4; x <= pos.m_123341_() + radius >> 4; ++x) {
            for (int z = pos.m_123343_() - radius >> 4; z <= pos.m_123343_() + radius >> 4; ++z) {
                AuraChunk chunk = (AuraChunk)data.auraChunksWithSpots.get(ChunkPos.m_45589_((int)x, (int)z));
                if (chunk == null) continue;
                consumer.accept(chunk);
            }
        }
    }

    public static List<ItemFrame> getAttachedItemFrames(Level level, BlockPos pos) {
        List frames = level.m_45976_(ItemFrame.class, new AABB(pos).m_82400_(0.25));
        for (int i = frames.size() - 1; i >= 0; --i) {
            ItemFrame frame = (ItemFrame)frames.get(i);
            BlockPos framePos = frame.m_31748_().m_142300_(frame.m_6350_().m_122424_());
            if (pos.equals((Object)framePos)) continue;
            frames.remove(i);
        }
        return frames;
    }

    public static ChunkAccess getLoadedChunk(LevelAccessor level, int x, int z) {
        ChunkSource chunkSource = level.m_7726_();
        if (chunkSource instanceof ServerChunkCache) {
            ServerChunkCache cache = (ServerChunkCache)chunkSource;
            return cache.m_143239_(ChunkPos.m_45589_((int)x, (int)z)) ? cache.m_7587_(x, z, ChunkStatus.f_62326_, false) : null;
        }
        return level.m_6522_(x, z, ChunkStatus.f_62326_, false);
    }

    public static int blendColors(int c1, int c2, float ratio) {
        int a = (int)((float)(c1 >> 24 & 0xFF) * ratio + (float)(c2 >> 24 & 0xFF) * (1.0f - ratio));
        int r = (int)((float)(c1 >> 16 & 0xFF) * ratio + (float)(c2 >> 16 & 0xFF) * (1.0f - ratio));
        int g = (int)((float)(c1 >> 8 & 0xFF) * ratio + (float)(c2 >> 8 & 0xFF) * (1.0f - ratio));
        int b = (int)((float)(c1 & 0xFF) * ratio + (float)(c2 & 0xFF) * (1.0f - ratio));
        return (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static boolean areItemsEqual(ItemStack first, ItemStack second, boolean nbt) {
        if (!ItemStack.m_41746_((ItemStack)first, (ItemStack)second)) {
            return false;
        }
        return !nbt || ItemStack.m_41658_((ItemStack)first, (ItemStack)second);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderItemInGui(ItemStack stack, int x, int y, float scale) {
        PoseStack poseStack = RenderSystem.m_157191_();
        poseStack.m_85836_();
        poseStack.m_85837_((double)x, (double)y, 0.0);
        poseStack.m_85841_(scale, scale, scale);
        RenderSystem.m_157182_();
        Minecraft.m_91087_().m_91291_().m_115123_(stack, 0, 0);
        Minecraft.m_91087_().m_91291_().m_115174_(Minecraft.m_91087_().f_91062_, stack, 0, 0, null);
        poseStack.m_85849_();
        RenderSystem.m_157182_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void renderWeirdBox(VertexConsumer buffer, double x, double y, double z, double width, double height, double depth, float r, float g, float b, float a) {
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y + height, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x + width, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z + depth).m_85950_(r, g, b, a).m_5752_();
        buffer.m_5483_(x, y, z).m_85950_(r, g, b, a).m_5752_();
    }

    public static InteractionResult putStackOnTile(Player player, InteractionHand hand, BlockPos pos, int slot, boolean sound) {
        IItemHandlerModifiable handler;
        BlockEntity tile = player.f_19853_.m_7702_(pos);
        if (tile instanceof BlockEntityImpl && (handler = ((BlockEntityImpl)tile).getItemHandler()) != null) {
            ItemStack remain;
            ItemStack handStack = player.m_21120_(hand);
            if (!handStack.m_41619_() && !ItemStack.m_41728_((ItemStack)(remain = handler.insertItem(slot, handStack, player.f_19853_.f_46443_)), (ItemStack)handStack)) {
                if (sound) {
                    player.f_19853_.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12013_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.f_19853_.f_46443_) {
                    player.m_21008_(hand, remain);
                }
                return InteractionResult.SUCCESS;
            }
            if (!handler.getStackInSlot(slot).m_41619_()) {
                if (sound) {
                    player.f_19853_.m_6263_(player, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, SoundEvents.f_12016_, SoundSource.PLAYERS, 0.75f, 1.0f);
                }
                if (!player.f_19853_.f_46443_) {
                    ItemStack stack = handler.getStackInSlot(slot);
                    if (!player.m_36356_(stack)) {
                        ItemEntity item = new ItemEntity(player.f_19853_, player.m_20185_(), player.m_20186_(), player.m_20189_(), stack);
                        player.f_19853_.m_7967_((Entity)item);
                    }
                    handler.setStackInSlot(slot, ItemStack.f_41583_);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.CONSUME;
    }

    public static ICapabilityProvider makeRechargeProvider(final ItemStack stack, final boolean needsSelected) {
        return new ICapabilityProvider(){
            private final LazyOptional<IAuraRecharge> recharge = LazyOptional.of(() -> (container, containerSlot, itemSlot, isSelected) -> {
                if (isSelected || !needsSelected) {
                    return Helper.rechargeAuraItem(stack, container, 300);
                }
                return false;
            });

            @Nullable
            public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                if (capability == NaturesAuraAPI.CAP_AURA_RECHARGE) {
                    return this.recharge.cast();
                }
                return LazyOptional.empty();
            }
        };
    }

    public static boolean rechargeAuraItem(ItemStack stack, IAuraContainer container, int toDrain) {
        if (stack.m_41773_() > 0 && container.drainAura(toDrain, true) >= toDrain) {
            stack.m_41721_(stack.m_41773_() - 1);
            container.drainAura(toDrain, false);
            return true;
        }
        return false;
    }

    public static BlockState getStateFromString(String raw) {
        String[] split = raw.split("\\[");
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(split[0]));
        if (block != null) {
            BlockState state = block.m_49966_();
            if (split.length > 1) {
                block0: for (String part : split[1].replace("]", "").split(",")) {
                    String[] keyValue = part.split("=");
                    for (Property prop : state.m_61147_()) {
                        BlockState changed = Helper.findProperty(state, prop, keyValue[0], keyValue[1]);
                        if (changed == null) continue;
                        state = changed;
                        continue block0;
                    }
                }
            }
            return state;
        }
        return null;
    }

    private static <T extends Comparable<T>> BlockState findProperty(BlockState state, Property<T> prop, String key, String newValue) {
        if (key.equals(prop.m_61708_())) {
            for (Comparable value : prop.m_6908_()) {
                if (!prop.m_6940_(value).equals(newValue)) continue;
                return (BlockState)state.m_61124_(prop, value);
            }
        }
        return null;
    }

    public static void addAdvancement(Player player, ResourceLocation advancement, String criterion) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer playerMp = (ServerPlayer)player;
        Advancement adv = playerMp.m_183503_().m_142572_().m_129889_().m_136041_(advancement);
        if (adv != null) {
            playerMp.m_8960_().m_135988_(adv, criterion);
        }
    }

    public static int getIngredientAmount(Ingredient ingredient) {
        int highestAmount = 0;
        for (ItemStack stack : ingredient.m_43908_()) {
            if (stack.m_41613_() <= highestAmount) continue;
            highestAmount = stack.m_41613_();
        }
        return highestAmount;
    }

    public static boolean isHoldingItem(Player player, Item item) {
        for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.m_21120_(hand);
            if (stack.m_41619_() || stack.m_41720_() != item) continue;
            return true;
        }
        return false;
    }

    public static boolean isEmpty(IItemHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            if (handler.getStackInSlot(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static AABB aabb(Vec3 pos) {
        return new AABB(pos.f_82479_, pos.f_82480_, pos.f_82481_, pos.f_82479_, pos.f_82480_, pos.f_82481_);
    }

    public static <T extends IForgeRegistryEntry<T>> void populateObjectHolders(Class<?> clazz, IForgeRegistry<T> registry) {
        for (Field entry : clazz.getFields()) {
            if (!Modifier.isStatic(entry.getModifiers())) continue;
            ResourceLocation location = new ResourceLocation("naturesaura", entry.getName().toLowerCase(Locale.ROOT));
            if (!registry.containsKey(location)) {
                NaturesAura.LOGGER.fatal("Couldn't find entry named " + location + " in registry " + registry.getRegistryName());
                continue;
            }
            try {
                entry.set(null, registry.getValue(location));
            }
            catch (IllegalAccessException e) {
                NaturesAura.LOGGER.error((Object)e);
            }
        }
    }

    public static ItemStack getEquippedItem(Predicate<ItemStack> predicate, Player player) {
        Optional<ItemStack> stack;
        if (Compat.hasCompat("curios") && (stack = CuriosApi.getCuriosHelper().findEquippedCurio(predicate, (LivingEntity)player).map(ImmutableTriple::getRight)).isPresent()) {
            return stack.get();
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slot = player.m_150109_().m_8020_(i);
            if (slot.m_41619_() || !predicate.test(slot)) continue;
            return slot;
        }
        return ItemStack.f_41583_;
    }
}

