/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityEndFlower;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.ICustomRenderType;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.reg.ModTileType;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jetbrains.annotations.Nullable;

public class BlockEndFlower
extends BushBlock
implements IModItem,
ICustomBlockState,
ICustomItemModel,
ICustomRenderType,
EntityBlock {
    protected static final VoxelShape SHAPE = BlockEndFlower.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0);

    public BlockEndFlower() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76315_).m_60910_().m_60978_(0.5f).m_60918_(SoundType.f_56740_));
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModRegistry.add(this);
        ModRegistry.add(new ModTileType(BlockEntityEndFlower::new, this));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        Vec3 vec3d = state.m_60824_(levelIn, pos);
        return SHAPE.m_83216_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_);
    }

    @SubscribeEvent
    public void onDragonTick(LivingEvent.LivingUpdateEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (living.f_19853_.f_46443_ || !(living instanceof EnderDragon)) {
            return;
        }
        EnderDragon dragon = (EnderDragon)living;
        if (dragon.f_31084_ < 150 || dragon.f_31084_ % 10 != 0) {
            return;
        }
        for (int i = 0; i < 6; ++i) {
            int z;
            int x = dragon.f_19853_.f_46441_.nextInt(256) - 128;
            BlockPos pos = new BlockPos(x, dragon.f_19853_.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = dragon.f_19853_.f_46441_.nextInt(256) - 128), z);
            if (!dragon.f_19853_.m_46749_(pos) || dragon.f_19853_.m_8055_(pos.m_7495_()).m_60734_() != Blocks.f_50259_) continue;
            dragon.f_19853_.m_46597_(pos, this.m_49966_());
        }
    }

    public boolean m_7898_(BlockState state, LevelReader levelIn, BlockPos pos) {
        return levelIn.m_8055_(pos.m_7495_()).m_60734_() == Blocks.f_50259_;
    }

    @Override
    public String getBaseName() {
        return "end_flower";
    }

    @javax.annotation.Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new BlockEntityEndFlower(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ITickableBlockEntity.createTickerHelper(type, ModBlockEntities.END_FLOWER);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        return willHarvest || super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public void m_6240_(Level levelIn, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        super.m_6240_(levelIn, player, pos, state, te, stack);
        levelIn.m_46597_(pos, Blocks.f_50016_.m_49966_());
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.m_78970_(LootContextParams.f_81462_);
        if (tile instanceof BlockEntityEndFlower && ((BlockEntityEndFlower)tile).isDrainMode) {
            return NonNullList.m_122779_();
        }
        return super.m_7381_(state, builder);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cross(this.getBaseName(), generator.modLoc("block/" + this.getBaseName())));
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "block/" + this.getBaseName());
    }

    @Override
    public Supplier<RenderType> getRenderType() {
        return RenderType::m_110463_;
    }
}

