/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityPickupStopper;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class BlockPickupStopper
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockPickupStopper() {
        super("pickup_stopper", BlockEntityPickupStopper.class, BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(2.0f).m_60918_(SoundType.f_56742_));
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        Player player = event.getPlayer();
        if (player != null && !player.m_6047_()) {
            ItemEntity item = event.getItem();
            BlockPos pos = item.m_142538_();
            Helper.getBlockEntitiesInArea((LevelAccessor)item.f_19853_, pos, 8, tile -> {
                if (!(tile instanceof BlockEntityPickupStopper)) {
                    return false;
                }
                BlockEntityPickupStopper stopper = (BlockEntityPickupStopper)((Object)tile);
                float radius = stopper.getRadius();
                if (radius <= 0.0f) {
                    return false;
                }
                BlockPos stopperPos = stopper.m_58899_();
                if (!new AABB(stopperPos).m_82400_((double)radius).m_82381_(item.m_142469_())) {
                    return false;
                }
                event.setCanceled(true);
                if (item.f_19853_.m_46467_() % 3L == 0L) {
                    PacketHandler.sendToAllAround(item.f_19853_, pos, 32, new PacketParticles((float)item.m_20185_(), (float)item.m_20186_(), (float)item.m_20189_(), PacketParticles.Type.PICKUP_STOPPER, new int[0]));
                }
                return true;
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        double radius;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BlockEntityPickupStopper && (radius = (double)((BlockEntityPickupStopper)tile).getRadius()) > 0.0) {
            return new AABB(pos).m_82400_(radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 16034370;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

