/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.BlockGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class BlockEntityGratedChute
extends BlockEntityImpl
implements ITickableBlockEntity {
    public boolean isBlacklist;
    private final ItemStackHandlerNA items = new ItemStackHandlerNA(1, this, true){

        @Override
        protected boolean canExtract(ItemStack stack, int slot, int amount) {
            return BlockEntityGratedChute.this.redstonePower <= 0;
        }

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return BlockEntityGratedChute.this.isBlacklist != BlockEntityGratedChute.this.isItemInFrame(stack);
        }
    };
    private int cooldown;

    public BlockEntityGratedChute(BlockPos pos, BlockState state) {
        super(ModBlockEntities.GRATED_CHUTE, pos, state);
    }

    @Override
    public void tick() {
        block12: {
            if (!this.f_58857_.f_46443_) {
                if (this.cooldown <= 0) {
                    IItemHandler handler;
                    BlockState state;
                    Object facing;
                    BlockEntity tile;
                    this.cooldown = 6;
                    if (this.redstonePower > 0) {
                        return;
                    }
                    ItemStack curr = this.items.getStackInSlot(0);
                    if (!curr.m_41619_() && (tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_((Direction)(facing = (Direction)(state = this.f_58857_.m_8055_(this.f_58858_)).m_61143_((Property)BlockGratedChute.FACING))))) != null && (handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.m_122424_()).orElse(null)) != null) {
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack left;
                            ItemStack theoreticalDrain = this.items.extractItem(0, 1, true);
                            if (theoreticalDrain.m_41619_() || !(left = handler.insertItem(i, theoreticalDrain, false)).m_41619_()) continue;
                            this.items.extractItem(0, 1, false);
                            break;
                        }
                    }
                    if (curr.m_41619_() || curr.m_41613_() < curr.m_41741_()) {
                        IItemHandler handlerUp;
                        List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 2), (double)(this.f_58858_.m_123343_() + 1)));
                        for (ItemEntity item : items) {
                            ItemStack left;
                            ItemStack stack;
                            if (!item.m_6084_() || (stack = item.m_32055_()).m_41619_() || ItemStack.m_41728_((ItemStack)stack, (ItemStack)(left = this.items.insertItem(0, stack, false)))) continue;
                            if (left.m_41619_()) {
                                item.m_6074_();
                            } else {
                                item.m_32045_(left);
                            }
                            break block12;
                        }
                        BlockEntity tileUp = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
                        if (tileUp != null && (handlerUp = (IItemHandler)tileUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN).orElse(null)) != null) {
                            for (int i = 0; i < handlerUp.getSlots(); ++i) {
                                ItemStack left;
                                ItemStack theoreticalDrain = handlerUp.extractItem(i, 1, true);
                                if (theoreticalDrain.m_41619_() || !(left = this.items.insertItem(0, theoreticalDrain, false)).m_41619_()) continue;
                                handlerUp.extractItem(i, 1, false);
                                break;
                            }
                        }
                    }
                } else {
                    --this.cooldown;
                }
            }
        }
    }

    private boolean isItemInFrame(ItemStack stack) {
        List<ItemFrame> frames = Helper.getAttachedItemFrames(this.f_58857_, this.f_58858_);
        if (frames.isEmpty()) {
            return false;
        }
        for (ItemFrame frame : frames) {
            ItemStack frameStack = frame.m_31822_();
            if (!Helper.areItemsEqual(stack, frameStack, true)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128405_("cooldown", this.cooldown);
            compound.m_128365_("items", (Tag)this.items.serializeNBT());
            compound.m_128379_("blacklist", this.isBlacklist);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.cooldown = compound.m_128451_("cooldown");
            this.items.deserializeNBT(compound.m_128469_("items"));
            this.isBlacklist = compound.m_128471_("blacklist");
        }
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.items;
    }
}

