/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockEntityItemDistributor
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int cooldown;
    private Direction currentSide = Direction.NORTH;
    public boolean isRandomMode;

    public BlockEntityItemDistributor(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ITEM_DISTRIBUTOR, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.cooldown > 0) {
            --this.cooldown;
            return;
        }
        this.cooldown = 1;
        IItemHandler above = this.getHandler(Direction.UP);
        if (above == null) {
            return;
        }
        IItemHandler dest = this.getNextSide();
        if (dest == null) {
            return;
        }
        for (int i = 0; i < above.getSlots(); ++i) {
            ItemStack stack = above.extractItem(i, 1, true);
            if (stack.m_41619_()) continue;
            for (int j = 0; j < dest.getSlots(); ++j) {
                ItemStack remain = dest.insertItem(j, stack, false);
                if (ItemStack.m_41728_((ItemStack)remain, (ItemStack)stack)) continue;
                above.extractItem(i, 1, false);
                this.cooldown = 3;
                return;
            }
        }
    }

    private IItemHandler getHandler(Direction direction) {
        BlockPos offset = this.f_58858_.m_142300_(direction);
        BlockEntity tile = this.f_58857_.m_7702_(offset);
        if (tile == null) {
            return null;
        }
        return (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, direction.m_122424_()).orElse(null);
    }

    private IItemHandler getNextSide() {
        if (this.isRandomMode) {
            ArrayList<IItemHandler> handlers = new ArrayList<IItemHandler>();
            for (int i = 0; i < 4; ++i) {
                IItemHandler handler = this.getHandler(Direction.values()[i]);
                if (handler == null) continue;
                handlers.add(handler);
            }
            if (handlers.isEmpty()) {
                return null;
            }
            return (IItemHandler)handlers.get(this.f_58857_.f_46441_.nextInt(handlers.size()));
        }
        for (int i = 0; i < 4; ++i) {
            this.currentSide = this.currentSide.m_122427_();
            IItemHandler handler = this.getHandler(this.currentSide);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.m_128405_("cooldown", this.cooldown);
            compound.m_128405_("side", this.currentSide.ordinal());
        }
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128379_("random", this.isRandomMode);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.cooldown = compound.m_128451_("cooldown");
            this.currentSide = Direction.values()[compound.m_128451_("side")];
        }
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.isRandomMode = compound.m_128471_("random");
        }
    }
}

