/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.BasicAuraContainer;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.BasicAuraType;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BlockEntityNatureAltar
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final BasicAuraContainer container = new BasicAuraContainer(null, 500000){

        @Override
        public int getAuraColor() {
            return IAuraType.forLevel(BlockEntityNatureAltar.this.f_58857_).getColor();
        }
    };
    private final ItemStack[] catalysts = new ItemStack[4];
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 1;
        }

        @Override
        protected boolean canInsert(ItemStack stack, int slot) {
            return BlockEntityNatureAltar.this.getRecipeForInput(stack) != null || stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).isPresent();
        }

        @Override
        protected boolean canExtract(ItemStack stack, int slot, int amount) {
            IAuraContainer cap = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null);
            if (cap != null) {
                return cap.storeAura(1, true) <= 0;
            }
            return BlockEntityNatureAltar.this.getRecipeForInput(stack) == null;
        }
    };
    @OnlyIn(value=Dist.CLIENT)
    public int bobTimer;
    public StructureState structureState = StructureState.INVALID;
    private AltarRecipe currentRecipe;
    private int timer;
    private int lastAura;
    private boolean firstTick = true;

    public BlockEntityNatureAltar(BlockPos pos, BlockState state) {
        super(ModBlockEntities.NATURE_ALTAR, pos, state);
    }

    @Override
    public void tick() {
        Random rand = this.f_58857_.f_46441_;
        if (this.f_58857_.m_46467_() % 40L == 0L) {
            int index = 0;
            for (int x = -2; x <= 2; x += 4) {
                for (int z = -2; z <= 2; z += 4) {
                    BlockPos offset = this.f_58858_.m_142082_(x, 1, z);
                    BlockState state = this.f_58857_.m_8055_(offset);
                    this.catalysts[index] = state.m_60734_().m_7397_((BlockGetter)this.f_58857_, offset, state);
                    ++index;
                }
            }
        }
        if (!this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 40L == 0L || this.firstTick) {
                StructureState newState = this.getNewState();
                if (newState != this.structureState) {
                    this.structureState = newState;
                    this.sendToClients();
                }
                this.firstTick = false;
            }
            if (this.structureState != StructureState.INVALID) {
                int toStore;
                BasicAuraType expectedType;
                int space = this.container.storeAura(300, true);
                BasicAuraType basicAuraType = expectedType = this.structureState == StructureState.NETHER ? NaturesAuraAPI.TYPE_NETHER : NaturesAuraAPI.TYPE_OVERWORLD;
                if (space > 0 && IAuraType.forLevel(this.f_58857_).isSimilar(expectedType) && (toStore = Math.min(IAuraChunk.getAuraInArea(this.f_58857_, this.f_58858_, 20), space)) > 0) {
                    BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 20, this.f_58858_);
                    IAuraChunk chunk = IAuraChunk.getAuraChunk(this.f_58857_, spot);
                    chunk.drainAura(spot, toStore);
                    this.container.storeAura(toStore, false);
                    if (this.f_58857_.m_46467_() % 3L == 0L) {
                        PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticleStream((float)this.f_58858_.m_123341_() + (float)rand.nextGaussian() * 10.0f, (float)this.f_58858_.m_123342_() + rand.nextFloat() * 10.0f, (float)this.f_58858_.m_123343_() + (float)rand.nextGaussian() * 10.0f, (float)this.f_58858_.m_123341_() + 0.5f, (float)this.f_58858_.m_123342_() + 0.5f, (float)this.f_58858_.m_123343_() + 0.5f, rand.nextFloat() * 0.1f + 0.1f, this.container.getAuraColor(), rand.nextFloat() + 1.0f));
                    }
                }
                ItemStack stack = this.items.getStackInSlot(0);
                IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER, null).orElse(null);
                if (!stack.m_41619_() && container != null) {
                    int stored;
                    int theoreticalDrain = this.container.drainAura(1000, true);
                    if (theoreticalDrain > 0 && (stored = container.storeAura(theoreticalDrain, false)) > 0) {
                        this.container.drainAura(stored, false);
                        if (this.f_58857_.m_46467_() % 4L == 0L) {
                            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.ALTAR_CONVERSION, this.container.getAuraColor()));
                        }
                    }
                } else if (this.currentRecipe == null) {
                    if (!stack.m_41619_()) {
                        this.currentRecipe = this.getRecipeForInput(stack);
                    }
                } else if (stack.m_41619_() || !this.currentRecipe.input.test(stack)) {
                    this.currentRecipe = null;
                    this.timer = 0;
                } else {
                    int req = Mth.m_14165_((double)((double)this.currentRecipe.aura / (double)this.currentRecipe.time));
                    if (this.container.getStoredAura() >= req) {
                        this.container.drainAura(req, false);
                        if (this.timer % 4 == 0) {
                            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.ALTAR_CONVERSION, this.container.getAuraColor()));
                        }
                        ++this.timer;
                        if (this.timer >= this.currentRecipe.time) {
                            this.items.setStackInSlot(0, this.currentRecipe.output.m_41777_());
                            this.currentRecipe = null;
                            this.timer = 0;
                            this.f_58857_.m_6263_(null, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, SoundEvents.f_11686_, SoundSource.BLOCKS, 0.65f, 1.0f);
                        }
                    }
                }
            }
            if (this.f_58857_.m_46467_() % 10L == 0L && this.lastAura != this.container.getStoredAura()) {
                this.lastAura = this.container.getStoredAura();
                this.sendToClients();
            }
        } else {
            if (this.structureState != StructureState.INVALID && rand.nextFloat() >= 0.7f) {
                int fourths = this.container.getMaxAura() / 4;
                if (this.container.getStoredAura() > 0) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() - 4.0f + rand.nextFloat(), (float)this.f_58858_.m_123342_() + 3.0f, (float)this.f_58858_.m_123343_() + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() + 4.0f + rand.nextFloat(), (float)this.f_58858_.m_123342_() + 3.0f, (float)this.f_58858_.m_123343_() + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths * 2) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() + rand.nextFloat(), (float)this.f_58858_.m_123342_() + 3.0f, (float)this.f_58858_.m_123343_() - 4.0f + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
                if (this.container.getStoredAura() >= fourths * 3) {
                    NaturesAuraAPI.instance().spawnMagicParticle((float)this.f_58858_.m_123341_() + rand.nextFloat(), (float)this.f_58858_.m_123342_() + 3.0f, (float)this.f_58858_.m_123343_() + 4.0f + rand.nextFloat(), 0.0, 0.0, 0.0, this.container.getAuraColor(), rand.nextFloat() * 3.0f + 1.0f, rand.nextInt(100) + 50, -0.05f, true, true);
                }
            }
            ++this.bobTimer;
        }
    }

    private AltarRecipe getRecipeForInput(ItemStack input) {
        IAuraType type = IAuraType.forLevel(this.f_58857_);
        for (AltarRecipe recipe : this.f_58857_.m_7465_().m_44056_(ModRecipes.ALTAR_TYPE, null, null)) {
            if (!recipe.input.test(input) || recipe.requiredType != null && !type.isSimilar(recipe.requiredType)) continue;
            if (recipe.catalyst == Ingredient.f_43901_) {
                return recipe;
            }
            for (ItemStack stack : this.catalysts) {
                if (!recipe.catalyst.test(stack)) continue;
                return recipe;
            }
        }
        return null;
    }

    private StructureState getNewState() {
        if (Multiblocks.ALTAR.isComplete(this.f_58857_, this.f_58858_)) {
            return StructureState.OVERWORLD;
        }
        if (Multiblocks.NETHER_ALTAR.isComplete(this.f_58857_, this.f_58858_)) {
            return StructureState.NETHER;
        }
        return StructureState.INVALID;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128365_("items", (Tag)this.items.serializeNBT());
            compound.m_128359_("state", this.structureState.name());
            this.container.writeNBT(compound);
        }
        if (type == BlockEntityImpl.SaveType.TILE && this.currentRecipe != null) {
            compound.m_128359_("recipe", this.currentRecipe.name.toString());
            compound.m_128405_("timer", this.timer);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.m_128469_("items"));
            if (compound.m_128441_("state")) {
                this.structureState = StructureState.valueOf(compound.m_128461_("state"));
            }
            this.container.readNBT(compound);
        }
        if (type == BlockEntityImpl.SaveType.TILE && compound.m_128441_("recipe")) {
            if (this.m_58898_()) {
                this.currentRecipe = this.f_58857_.m_7465_().m_44043_(new ResourceLocation(compound.m_128461_("recipe"))).orElse(null);
            }
            this.timer = compound.m_128451_("timer");
        }
    }

    @Override
    public IAuraContainer getAuraContainer() {
        return this.container;
    }

    @Override
    public IItemHandlerModifiable getItemHandler() {
        return this.items;
    }

    public static enum StructureState {
        INVALID,
        NETHER,
        OVERWORLD;

    }
}

