/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;

public class BlockEntityRFConverter
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final RFStorage storage = new RFStorage();
    private final LazyOptional<IEnergyStorage> storageOptional = LazyOptional.of(() -> this.storage);
    private int lastEnergy;

    public BlockEntityRFConverter(BlockPos pos, BlockState state) {
        super(ModBlockEntities.RF_CONVERTER, pos, state);
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        compound.m_128405_("energy", this.storage.getEnergyStored());
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        this.storage.setEnergy(compound.m_128451_("energy"));
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_ && ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue()) {
            int emptyPart;
            if (this.lastEnergy != this.storage.getEnergyStored() && this.f_58857_.m_46467_() % 10L == 0L) {
                this.sendToClients();
                this.lastEnergy = this.storage.getEnergyStored();
            }
            for (Direction facing : Direction.values()) {
                int extracted;
                int canStore;
                IEnergyStorage storage;
                BlockEntity tile = this.f_58857_.m_7702_(this.f_58858_.m_142300_(facing));
                if (tile == null || (storage = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing.m_122424_()).orElse(null)) == null || (canStore = storage.receiveEnergy(Integer.MAX_VALUE, true)) <= 0 || (extracted = this.storage.extractEnergy(canStore, false)) <= 0) continue;
                storage.receiveEnergy(extracted, false);
                break;
            }
            if ((emptyPart = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) <= 0) {
                return;
            }
            if (this.f_58857_.m_46467_() % 20L != 0L) {
                return;
            }
            if (!Multiblocks.RF_CONVERTER.isComplete(this.f_58857_, this.f_58858_)) {
                return;
            }
            int aura = IAuraChunk.getAuraInArea(this.f_58857_, this.f_58858_, 45);
            if (aura <= 1000000) {
                return;
            }
            int amountToGen = Math.min(Math.min(10000, aura / 1000), emptyPart);
            int amountToUse = Mth.m_14165_((double)((double)amountToGen / (Double)ModConfig.instance.auraToRFRatio.get()));
            this.storage.setEnergy(this.storage.getEnergyStored() + amountToGen);
            BlockPos pos = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 45, this.f_58858_);
            IAuraChunk.getAuraChunk(this.f_58857_, pos).drainAura(pos, amountToUse);
            PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.RF_CONVERTER, new int[0]));
        }
    }

    @Override
    @Nullable
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.storageOptional.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public void m_7651_() {
        super.m_7651_();
        this.storageOptional.invalidate();
    }

    public static class RFStorage
    extends EnergyStorage {
        public RFStorage() {
            super(50000, 0, 2000);
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

