/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.PlayerList;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;

public class BlockEntityTimeChanger
extends BlockEntityImpl
implements ITickableBlockEntity {
    private long goalTime;

    public BlockEntityTimeChanger(BlockPos pos, BlockState state) {
        super(ModBlockEntities.TIME_CHANGER, pos, state);
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            List<ItemFrame> frames = Helper.getAttachedItemFrames(this.f_58857_, this.f_58858_);
            for (ItemFrame frame : frames) {
                ItemStack frameStack = frame.m_31822_();
                if (frameStack.m_41619_() || frameStack.m_41720_() != ModItems.CLOCK_HAND) continue;
                if (this.goalTime > 0L) {
                    long current = this.f_58857_.m_46468_();
                    long toAdd = Math.min(75L, this.goalTime - current);
                    if (toAdd <= 0L) {
                        this.goalTime = 0L;
                        this.sendToClients();
                        return;
                    }
                    ((ServerLevelData)this.f_58857_.m_6106_()).m_6247_(current + toAdd);
                    BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
                    IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, (int)toAdd * 20);
                    if (this.f_58857_ instanceof ServerLevel) {
                        PlayerList list = this.f_58857_.m_142572_().m_6846_();
                        list.m_11268_((Packet)new ClientboundSetTimePacket(this.f_58857_.m_46467_(), this.f_58857_.m_46468_(), this.f_58857_.m_46469_().m_46207_(GameRules.f_46140_)));
                    }
                    return;
                }
                if (this.f_58857_.m_46467_() % 20L != 0L) {
                    return;
                }
                List items = this.f_58857_.m_6443_(ItemEntity.class, new AABB(this.f_58858_).m_82400_(1.0), Entity::m_6084_);
                for (ItemEntity item : items) {
                    ItemStack stack;
                    if (item.m_32063_() || (stack = item.m_32055_()).m_41619_() || stack.m_41720_() != Items.f_42524_) continue;
                    int dayGoal = Mth.m_14143_((float)((float)frame.m_31823_() / 8.0f * 24000.0f)) + 18000;
                    long current = this.f_58857_.m_46468_();
                    long toMove = (24000L - current % 24000L + (long)dayGoal) % 24000L;
                    this.goalTime = current + toMove;
                    this.sendToClients();
                    if (stack.m_41613_() <= 1) {
                        item.m_6074_();
                    } else {
                        stack.m_41774_(1);
                        item.m_32045_(stack);
                    }
                    return;
                }
            }
            if (this.goalTime > 0L) {
                this.goalTime = 0L;
                this.sendToClients();
            }
        } else if (this.goalTime > 0L && this.f_58857_.f_46441_.nextFloat() >= 0.25f) {
            double angle = Math.toRadians((float)this.f_58857_.m_46468_() * 5.0f % 360.0f);
            double x = (double)this.f_58858_.m_123341_() + 0.5 + Math.sin(angle) * 3.0;
            double z = (double)this.f_58858_.m_123343_() + 0.5 + Math.cos(angle) * 3.0;
            int color = this.goalTime % 24000L > 12000L ? 0xE2E2E2 : 16771366;
            NaturesAuraAPI.instance().spawnMagicParticle(x, (float)this.f_58858_.m_123342_() + 0.1f, z, 0.0, 0.12f, 0.0, color, 1.0f + this.f_58857_.f_46441_.nextFloat() * 2.0f, this.f_58857_.f_46441_.nextInt(100) + 100, 0.0f, false, true);
            NaturesAuraAPI.instance().spawnMagicParticle(x, (float)this.f_58858_.m_123342_() + 0.1f, z, 0.0, 0.0, 0.0, IAuraType.forLevel(this.f_58857_).getColor(), 1.0f + this.f_58857_.f_46441_.nextFloat(), 150, 0.0f, false, true);
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128356_("goal", this.goalTime);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.goalTime = compound.m_128454_("goal");
        }
    }
}

