/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.WeatherType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.commons.lang3.tuple.Pair;

public class BlockEntityWeatherChanger
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int processTime;
    private WeatherType type;
    private int itemAmount;

    public BlockEntityWeatherChanger(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WEATHER_CHANGER, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_) {
            if (this.f_58857_.m_46467_() % 10L != 0L) {
                return;
            }
            if (this.processTime <= 0) {
                return;
            }
            int color = this.type == WeatherType.SUN ? 16111426 : (this.type == WeatherType.RAIN ? 5069539 : 3617351);
            for (int r = 0; r < 360; r += 20) {
                double xOff = Math.cos(Math.toRadians(r)) * 3.0;
                double zOff = Math.sin(Math.toRadians(r)) * 3.0;
                for (int i = this.f_58857_.f_46441_.nextInt(3); i > 0; --i) {
                    NaturesAuraAPI.instance().spawnMagicParticle((double)((float)this.f_58858_.m_123341_() + 0.5f) + xOff, this.f_58858_.m_123342_(), (double)((float)this.f_58858_.m_123343_() + 0.5f) + zOff, this.f_58857_.f_46441_.nextGaussian() * (double)0.02f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.1f, this.f_58857_.f_46441_.nextGaussian() * (double)0.02f, color, this.f_58857_.f_46441_.nextFloat() * 2.0f + 1.0f, this.f_58857_.f_46441_.nextInt(80) + 80, 0.0f, false, true);
                }
            }
            return;
        }
        if (this.processTime > 0) {
            if (this.processTime % 20 == 0) {
                BlockPos spot = IAuraChunk.getHighestSpot(this.f_58857_, this.f_58858_, 35, this.f_58858_);
                IAuraChunk.getAuraChunk(this.f_58857_, spot).drainAura(spot, 30000 * Mth.m_14167_((float)((float)this.itemAmount * 0.75f)));
            }
            --this.processTime;
            if (this.processTime <= 0) {
                this.sendToClients();
                int time = 6000 * this.itemAmount;
                ServerLevel server = (ServerLevel)this.f_58857_;
                switch (this.type) {
                    case SUN: {
                        server.m_8606_(time, 0, false, false);
                        break;
                    }
                    case RAIN: {
                        server.m_8606_(0, time, true, false);
                        break;
                    }
                    case THUNDERSTORM: {
                        server.m_8606_(0, time, true, true);
                    }
                }
            }
        } else {
            if (this.f_58857_.m_46467_() % 20L != 0L) {
                return;
            }
            Pair<WeatherType, Integer> type = this.getNextWeatherType();
            if (type == null) {
                return;
            }
            this.type = (WeatherType)((Object)type.getLeft());
            this.itemAmount = (Integer)type.getRight();
            this.processTime = 100;
            this.sendToClients();
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.m_128405_("time", this.processTime);
            if (this.type != null) {
                compound.m_128405_("weather", this.type.ordinal());
            }
            compound.m_128405_("amount", this.itemAmount);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.processTime = compound.m_128451_("time");
            this.type = WeatherType.values()[compound.m_128451_("weather")];
            this.itemAmount = compound.m_128451_("amount");
        }
    }

    private Pair<WeatherType, Integer> getNextWeatherType() {
        AABB area = new AABB(this.f_58858_).m_82400_(2.0);
        List items = this.f_58857_.m_6443_(ItemEntity.class, area, Entity::m_6084_);
        for (ItemEntity entity : items) {
            if (entity.m_32063_()) continue;
            ItemStack stack = entity.m_32055_();
            for (Map.Entry<ItemStack, WeatherType> entry : NaturesAuraAPI.WEATHER_CHANGER_CONVERSIONS.entrySet()) {
                if (!Helper.areItemsEqual(stack, entry.getKey(), true)) continue;
                entity.m_32045_(ItemStack.f_41583_);
                entity.m_6074_();
                return Pair.of((Object)((Object)entry.getValue()), (Object)stack.m_41613_());
            }
        }
        return null;
    }
}

