/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;

public class NetherGrassEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "nether_grass");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(20, Mth.m_14167_((float)((float)Math.abs(aura) / 100000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = Mth.m_14045_((int)(Math.abs(aura) / 100000), (int)5, (int)35);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.f_19853_, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.f_19853_, player.m_142538_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)ModBlocks.NETHER_GRASS);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (level.m_46467_() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        block0: for (int i = this.amount / 2 + level.f_46441_.nextInt(this.amount / 2); i >= 0; --i) {
            int x = Mth.m_14107_((double)((double)pos.m_123341_() + level.f_46441_.nextGaussian() * (double)this.dist));
            int y = Mth.m_14107_((double)((double)pos.m_123342_() + level.f_46441_.nextGaussian() * (double)this.dist));
            int z = Mth.m_14107_((double)((double)pos.m_123343_() + level.f_46441_.nextGaussian() * (double)this.dist));
            for (int yOff = -5; yOff <= 5; ++yOff) {
                BlockState state;
                BlockPos up;
                BlockPos goalPos = new BlockPos(x, y + yOff, z);
                if (!(goalPos.m_123331_((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.m_46749_(goalPos) || NaturesAuraAPI.instance().isEffectPowderActive(level, goalPos, NAME) || level.m_8055_(up = goalPos.m_7494_()).m_60783_((BlockGetter)level, up, Direction.DOWN) || !(state = level.m_8055_(goalPos)).m_204336_(Tags.Blocks.NETHERRACK)) continue;
                level.m_46597_(goalPos, ModBlocks.NETHER_GRASS.m_49966_());
                BlockPos closestSpot = IAuraChunk.getHighestSpot(level, goalPos, 25, pos);
                IAuraChunk.getAuraChunk(level, closestSpot).drainAura(closestSpot, 500);
                PacketHandler.sendToAllAround(level, goalPos, 32, new PacketParticles(goalPos.m_123341_(), (float)goalPos.m_123342_() + 0.5f, goalPos.m_123343_(), PacketParticles.Type.PLANT_BOOST, new int[0]));
                continue block0;
            }
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherGrassEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

