/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import org.apache.commons.lang3.tuple.Pair;

public class PlantBoostEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "plant_boost");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(45, Mth.m_14167_((float)((float)Math.abs(aura) / 100000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = Mth.m_14045_((int)(Math.abs(aura) / 150000), (int)5, (int)35);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.f_19853_, pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.f_19853_, player.m_142538_(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Items.f_42404_);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + level.f_46441_.nextInt(this.amount / 2); i >= 0; --i) {
            BlockState state;
            Block block;
            int z;
            int x = Mth.m_14143_((float)((float)pos.m_123341_() + (2.0f * level.f_46441_.nextFloat() - 1.0f) * (float)this.dist));
            BlockPos plantPos = new BlockPos(x, level.m_6924_(Heightmap.Types.WORLD_SURFACE, x, z = Mth.m_14143_((float)((float)pos.m_123343_() + (2.0f * level.f_46441_.nextFloat() - 1.0f) * (float)this.dist))), z).m_7495_();
            if (!(plantPos.m_123331_((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.m_46749_(plantPos) || NaturesAuraAPI.instance().isEffectPowderActive(level, plantPos, NAME) || !((block = (state = level.m_8055_(plantPos)).m_60734_()) instanceof BonemealableBlock)) continue;
            BonemealableBlock growable = (BonemealableBlock)block;
            if (block instanceof DoublePlantBlock || block instanceof TallGrassBlock || block == Blocks.f_50440_ || !growable.m_7370_((BlockGetter)level, plantPos, state, false)) continue;
            try {
                growable.m_7719_((ServerLevel)level, level.f_46441_, plantPos, state);
            }
            catch (Exception exception) {
                // empty catch block
            }
            BlockPos closestSpot = IAuraChunk.getHighestSpot(level, plantPos, 25, pos);
            IAuraChunk.getAuraChunk(level, closestSpot).drainAura(closestSpot, 3500);
            PacketHandler.sendToAllAround(level, plantPos, 32, new PacketParticles(plantPos.m_123341_(), plantPos.m_123342_(), plantPos.m_123343_(), PacketParticles.Type.PLANT_BOOST, new int[0]));
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.plantBoostEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

