/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import com.google.common.collect.ImmutableList;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.compat.jei.JEINaturesAuraPlugin;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class AltarCategory
implements IRecipeCategory<AltarRecipe> {
    private final IDrawable background;
    private final ItemStack altar = new ItemStack((ItemLike)ModBlocks.NATURE_ALTAR);

    public AltarCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("naturesaura", "textures/gui/jei/altar.png"), 0, 0, 103, 57);
    }

    public ResourceLocation getUid() {
        return JEINaturesAuraPlugin.ALTAR;
    }

    public Class<? extends AltarRecipe> getRecipeClass() {
        return AltarRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("container." + JEINaturesAuraPlugin.ALTAR + ".name");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(AltarRecipe altarRecipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object[])altarRecipe.input.m_43908_());
        if (altarRecipe.catalyst != Ingredient.f_43901_) {
            builder.add((Object[])altarRecipe.catalyst.m_43908_());
        }
        if (altarRecipe.requiredType != null) {
            builder.add((Object)altarRecipe.getDimensionBottle());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)altarRecipe.output);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, AltarRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        group.init(0, true, 0, 18);
        group.set(0, Arrays.asList(recipe.input.m_43908_()));
        group.init(1, false, 80, 18);
        group.set(1, recipe.output);
        group.init(2, true, 26, 18);
        group.set(2, recipe.catalyst == Ingredient.f_43901_ ? Collections.singletonList(this.altar) : Arrays.asList(recipe.catalyst.m_43908_()));
        group.init(3, true, 51, 18);
        if (recipe.requiredType != null) {
            group.set(3, recipe.getDimensionBottle());
        }
    }
}

