/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.ellpeck.naturesaura.compat.jei.JEINaturesAuraPlugin;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeSpawnEggItem;

public class AnimalSpawnerCategory
implements IRecipeCategory<AnimalSpawnerRecipe> {
    private final IDrawable background;
    private final Map<EntityType<?>, Entity> entityCache = new HashMap();

    public AnimalSpawnerCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("naturesaura", "textures/gui/jei/animal_spawner.png"), 0, 0, 72, 86);
    }

    private static void renderEntity(PoseStack matrixstack, int x, int y, float scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        PoseStack posestack = RenderSystem.m_157191_();
        posestack.m_85836_();
        posestack.m_85837_((double)x, (double)y, 1050.0);
        posestack.m_85841_(1.0f, 1.0f, -1.0f);
        RenderSystem.m_157182_();
        matrixstack.m_85837_(0.0, 0.0, 1000.0);
        matrixstack.m_85841_(scale, scale, scale);
        Quaternion quaternion = Vector3f.f_122227_.m_122240_(180.0f);
        Quaternion quaternion1 = Vector3f.f_122223_.m_122240_(f1 * 20.0f);
        quaternion.m_80148_(quaternion1);
        matrixstack.m_85845_(quaternion);
        float f2 = entity.f_20883_;
        float f3 = entity.m_146908_();
        float f4 = entity.m_146909_();
        float f5 = entity.f_20886_;
        float f6 = entity.f_20885_;
        entity.f_20883_ = 180.0f + f * 20.0f;
        entity.m_146922_(180.0f + f * 40.0f);
        entity.m_146926_(-f1 * 20.0f);
        entity.f_20885_ = entity.m_146908_();
        entity.f_20886_ = entity.m_146908_();
        Lighting.m_166384_();
        EntityRenderDispatcher entityrenderermanager = Minecraft.m_91087_().m_91290_();
        quaternion1.m_80157_();
        entityrenderermanager.m_114412_(quaternion1);
        entityrenderermanager.m_114468_(false);
        MultiBufferSource.BufferSource buff = Minecraft.m_91087_().m_91269_().m_110104_();
        entityrenderermanager.m_114384_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (MultiBufferSource)buff, 0xF000F0);
        buff.m_109911_();
        entityrenderermanager.m_114468_(true);
        entity.f_20883_ = f2;
        entity.m_146922_(f3);
        entity.m_146926_(f4);
        entity.f_20886_ = f5;
        entity.f_20885_ = f6;
        posestack.m_85849_();
        RenderSystem.m_157182_();
        Lighting.m_84931_();
    }

    public ResourceLocation getUid() {
        return JEINaturesAuraPlugin.SPAWNER;
    }

    public Class<? extends AnimalSpawnerRecipe> getRecipeClass() {
        return AnimalSpawnerRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("container." + JEINaturesAuraPlugin.SPAWNER + ".name");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(AnimalSpawnerRecipe animalSpawnerRecipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient ing : animalSpawnerRecipe.ingredients) {
            builder.add((Object[])ing.m_43908_());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ForgeSpawnEggItem.fromEntityType(animalSpawnerRecipe.entity)));
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, AnimalSpawnerRecipe recipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        for (int i = 0; i < recipe.ingredients.length; ++i) {
            group.init(i, true, i * 18, 68);
            group.set(i, Arrays.asList(recipe.ingredients[i].m_43908_()));
        }
    }

    public void draw(AnimalSpawnerRecipe recipe, PoseStack matrixStack, double mouseX, double mouseY) {
        Minecraft minecraft = Minecraft.m_91087_();
        Entity entity = this.entityCache.get(recipe.entity);
        if (entity == null) {
            entity = recipe.makeEntity((Level)minecraft.f_91073_, BlockPos.f_121853_);
            this.entityCache.put(recipe.entity, entity);
        }
        matrixStack.m_85836_();
        float size = Math.max(1.0f, Math.max(recipe.entity.m_20678_(), recipe.entity.m_20679_()));
        AnimalSpawnerCategory.renderEntity(matrixStack, 35, 55, 100.0f / size * 0.4f, 40.0f, size * 0.5f, (LivingEntity)entity);
        matrixStack.m_85849_();
        String name = recipe.entity.m_20676_().getString();
        minecraft.f_91062_.m_92750_(matrixStack, name, 36.0f - (float)minecraft.f_91062_.m_92895_(name) / 2.0f, 55.0f, 0xFFFFFF);
    }
}

