/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import com.google.common.collect.ImmutableList;
import de.ellpeck.naturesaura.compat.jei.JEINaturesAuraPlugin;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Ingredient;

public class TreeRitualCategory
implements IRecipeCategory<TreeRitualRecipe> {
    private final IDrawable background;

    public TreeRitualCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(new ResourceLocation("naturesaura", "textures/gui/jei/tree_ritual.png"), 0, 0, 146, 86);
    }

    public ResourceLocation getUid() {
        return JEINaturesAuraPlugin.TREE_RITUAL;
    }

    public Class<? extends TreeRitualRecipe> getRecipeClass() {
        return TreeRitualRecipe.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("container." + JEINaturesAuraPlugin.TREE_RITUAL + ".name");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setIngredients(TreeRitualRecipe treeRitualRecipe, IIngredients iIngredients) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Ingredient ing : treeRitualRecipe.ingredients) {
            builder.add((Object[])ing.m_43908_());
        }
        builder.add((Object[])treeRitualRecipe.saplingType.m_43908_());
        iIngredients.setInputs(VanillaTypes.ITEM, (List)builder.build());
        iIngredients.setOutput(VanillaTypes.ITEM, (Object)treeRitualRecipe.result);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, TreeRitualRecipe treeRitualRecipe, IIngredients iIngredients) {
        IGuiItemStackGroup group = iRecipeLayout.getItemStacks();
        group.init(0, true, 34, 34);
        group.set(0, Arrays.asList(treeRitualRecipe.saplingType.m_43908_()));
        group.init(1, true, 124, 34);
        group.set(1, treeRitualRecipe.result);
        int[][] positions = new int[][]{{35, 1}, {35, 69}, {1, 35}, {69, 35}, {12, 12}, {58, 58}, {58, 12}, {12, 58}};
        for (int i = 0; i < treeRitualRecipe.ingredients.length; ++i) {
            group.init(i + 2, true, positions[i][0] - 1, positions[i][1] - 1);
            group.set(i + 2, Arrays.asList(treeRitualRecipe.ingredients[i].m_43908_()));
        }
    }
}

