/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.gen;

import com.mojang.serialization.Codec;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class LevelGenAncientTree
extends Feature<NoneFeatureConfiguration> {
    public LevelGenAncientTree() {
        super(Codec.unit((Object)FeatureConfiguration.f_67737_));
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> ctx) {
        WorldGenLevel level = ctx.m_159774_();
        BlockPos pos = ctx.m_159777_();
        Random rand = ctx.m_159776_();
        int height = rand.nextInt(3) + 5;
        BlockPos trunkTop = pos.m_6630_(height);
        this.m_5974_((LevelWriter)level, pos, Blocks.f_50016_.m_49966_());
        int rootsAmount = rand.nextInt(4) + 5;
        for (int i = 0; i < rootsAmount; ++i) {
            int length = rand.nextInt(3) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)rootsAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = pos.m_142022_((double)x, 0.0, (double)z);
            while (level.m_7433_(goal, state -> state.m_60767_().m_76336_()) && !((goal = goal.m_7495_()).m_123331_((Vec3i)pos) >= 100.0)) {
            }
            this.makeBranch(level, pos.m_6630_(rand.nextInt(1)), goal, ModBlocks.ANCIENT_BARK.m_49966_(), false);
        }
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                for (int i = height - (x + z) * (rand.nextInt(2) + 2); i >= 0; --i) {
                    BlockPos goal = pos.m_142082_(x, i, z);
                    if (level.m_7433_(goal, s -> !TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)goal))) continue;
                    this.m_5974_((LevelWriter)level, goal, (BlockState)ModBlocks.ANCIENT_LOG.m_49966_().m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)Direction.Axis.Y));
                }
            }
        }
        this.makeLeaves(level, trunkTop.m_6630_(rand.nextInt(2) - 1), ModBlocks.ANCIENT_LEAVES.m_49966_(), rand.nextInt(2) + 3, rand);
        int branchAmount = rand.nextInt(3) + 4;
        for (int i = 0; i < branchAmount; ++i) {
            int length = rand.nextInt(2) + 3;
            float angle = (float)Math.PI * 2 * ((float)i / (float)branchAmount);
            float x = (float)Math.sin(angle) * (float)length;
            float z = (float)Math.cos(angle) * (float)length;
            BlockPos goal = trunkTop.m_142022_((double)x, (double)(rand.nextInt(3) + 1), (double)z);
            this.makeBranch(level, trunkTop, goal, ModBlocks.ANCIENT_LOG.m_49966_(), true);
            this.makeLeaves(level, goal, ModBlocks.ANCIENT_LEAVES.m_49966_(), rand.nextInt(2) + 2, rand);
        }
        return true;
    }

    private void makeBranch(WorldGenLevel level, BlockPos first, BlockPos second, BlockState state, boolean hasAxis) {
        BlockPos pos = second.m_142082_(-first.m_123341_(), -first.m_123342_(), -first.m_123343_());
        int length = this.getHighestCoord(pos);
        float stepX = (float)pos.m_123341_() / (float)length;
        float stepY = (float)pos.m_123342_() / (float)length;
        float stepZ = (float)pos.m_123343_() / (float)length;
        for (int i = 0; i <= length; ++i) {
            BlockPos goal = first.m_142022_((double)(0.5f + (float)i * stepX), (double)(0.5f + (float)i * stepY), (double)(0.5f + (float)i * stepZ));
            if (level.m_7433_(goal, s -> !TreeFeature.m_67272_((LevelSimulatedReader)level, (BlockPos)goal))) continue;
            if (hasAxis) {
                Direction.Axis axis = this.getLogAxis(first, goal);
                this.m_5974_((LevelWriter)level, goal, (BlockState)state.m_61124_((Property)RotatedPillarBlock.f_55923_, (Comparable)axis));
                continue;
            }
            this.m_5974_((LevelWriter)level, goal, state);
        }
    }

    private void makeLeaves(WorldGenLevel level, BlockPos pos, BlockState state, int radius, Random rand) {
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos goal = pos.m_142082_(x, y, z);
                    if (!(pos.m_123331_((Vec3i)goal) <= (double)(radius * radius + rand.nextInt(3) - 1)) || level.m_7433_(goal, s -> s.m_60767_() == Material.f_76274_) || !level.m_7433_(goal, st -> st.m_60767_() != Material.f_76320_ && st.m_60734_() != Blocks.f_50493_ && st.m_60734_() != Blocks.f_50034_)) continue;
                    this.m_5974_((LevelWriter)level, goal, state);
                }
            }
        }
    }

    private int getHighestCoord(BlockPos pos) {
        return Math.max(Mth.m_14040_((int)pos.m_123341_()), Math.max(Mth.m_14040_((int)pos.m_123342_()), Mth.m_14040_((int)pos.m_123343_())));
    }

    private Direction.Axis getLogAxis(BlockPos pos, BlockPos goal) {
        int y;
        Direction.Axis axis = Direction.Axis.Y;
        int x = Math.abs(goal.m_123341_() - pos.m_123341_());
        int highest = Math.max(x, y = Math.abs(goal.m_123343_() - pos.m_123343_()));
        if (highest > 0) {
            if (x == highest) {
                axis = Direction.Axis.X;
            } else if (y == highest) {
                axis = Direction.Axis.Z;
            }
        }
        return axis;
    }
}

