/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemHoe
extends HoeItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemHoe(String baseName, Tier material, int speed) {
        super(material, speed, 0.0f, new Item.Properties().m_41491_(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this == ModItems.INFUSED_IRON_HOE) {
            Level level = context.m_43725_();
            InteractionResult result = super.m_6225_(context);
            if (!level.f_46443_ && result.m_19077_()) {
                ItemStack seed = ItemStack.f_41583_;
                Random random = level.m_5822_();
                BlockPos pos = context.m_8083_();
                if (random.nextInt(5) == 0) {
                    seed = new ItemStack((ItemLike)Items.f_42404_);
                } else if (random.nextInt(10) == 0) {
                    int rand = random.nextInt(3);
                    if (rand == 0) {
                        seed = new ItemStack((ItemLike)Items.f_42578_);
                    } else if (rand == 1) {
                        seed = new ItemStack((ItemLike)Items.f_42577_);
                    } else if (rand == 2) {
                        seed = new ItemStack((ItemLike)Items.f_42733_);
                    }
                }
                if (!seed.m_41619_()) {
                    ItemEntity item = new ItemEntity(level, (double)((float)pos.m_123341_() + random.nextFloat()), (double)((float)pos.m_123342_() + 1.0f), (double)((float)pos.m_123343_() + random.nextFloat()), seed);
                    level.m_7967_((Entity)item);
                }
            }
            return result;
        }
        if (this == ModItems.SKY_HOE) {
            boolean success = false;
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos offset = context.m_8083_().m_142082_(x, 0, z);
                    BlockHitResult newResult = new BlockHitResult(context.m_43720_(), context.m_43719_(), offset, context.m_43721_());
                    UseOnContext newContext = new UseOnContext(context.m_43723_(), context.m_43724_(), newResult);
                    success |= super.m_6225_(newContext) == InteractionResult.SUCCESS;
                }
            }
            return success ? InteractionResult.SUCCESS : InteractionResult.PASS;
        }
        return super.m_6225_(context);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos pos, Player player) {
        if (stack.m_41720_() == ModItems.SKY_HOE) {
            if (!(player.f_19853_.m_8055_(pos).m_60734_() instanceof BushBlock)) {
                return false;
            }
            if (!player.f_19853_.f_46443_) {
                int range = 3;
                for (int x = -range; x <= range; ++x) {
                    for (int y = -range; y <= range; ++y) {
                        for (int z = -range; z <= range; ++z) {
                            BlockPos offset;
                            BlockState otherState;
                            if (x == 0 && y == 0 && z == 0 || !((otherState = player.f_19853_.m_8055_(offset = pos.m_142082_(x, y, z))).m_60734_() instanceof BushBlock)) continue;
                            player.f_19853_.m_46961_(offset, true);
                        }
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

