/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class ItemPickaxe
extends PickaxeItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemPickaxe(String baseName, Tier material, int damage, float speed) {
        super(material, damage, speed, new Item.Properties().m_41491_(NaturesAura.CREATIVE_TAB));
        this.baseName = baseName;
        ModRegistry.add(this);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        if (this == ModItems.INFUSED_IRON_PICKAXE) {
            Player player = context.m_43723_();
            Level level = context.m_43725_();
            BlockPos pos = context.m_8083_();
            ItemStack stack = player.m_21120_(context.m_43724_());
            BlockState state = level.m_8055_(pos);
            BlockState result = (BlockState)NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.get((Object)state);
            if (result != null) {
                if (!level.f_46443_) {
                    level.m_46597_(pos, result);
                    LevelData data = (LevelData)ILevelData.getLevelData(level);
                    data.addMossStone(pos);
                }
                level.m_5594_(player, pos, SoundEvents.f_12447_, SoundSource.BLOCKS, 1.0f, 1.0f);
                stack.m_41622_(15, (LivingEntity)player, p -> p.m_21190_(context.m_43724_()));
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6883_(ItemStack stack, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (this == ModItems.SKY_PICKAXE) {
            if (!(entityIn instanceof Player)) {
                return;
            }
            if (!isSelected || levelIn.f_46443_) {
                return;
            }
            AABB bounds = new AABB(entityIn.m_142538_()).m_82400_(3.5);
            for (ItemEntity item : levelIn.m_45976_(ItemEntity.class, bounds)) {
                if (item.f_19797_ >= 5 || !item.m_6084_()) continue;
                item.m_32010_(0);
                item.m_6123_((Player)entityIn);
            }
        }
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return Helper.makeRechargeProvider(stack, true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

