/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class TreeRitualRecipe
extends ModRecipe {
    public final Ingredient saplingType;
    public final Ingredient[] ingredients;
    public final ItemStack result;
    public final int time;

    public TreeRitualRecipe(ResourceLocation name, Ingredient saplingType, ItemStack result, int time, Ingredient ... ingredients) {
        super(name);
        this.saplingType = saplingType;
        this.ingredients = ingredients;
        this.result = result;
        this.time = time;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.TREE_RITUAL_SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.TREE_RITUAL_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<TreeRitualRecipe> {
        public TreeRitualRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            ArrayList<Ingredient> ings = new ArrayList<Ingredient>();
            for (JsonElement element : json.getAsJsonArray("ingredients")) {
                ings.add(Ingredient.m_43917_((JsonElement)element));
            }
            return new TreeRitualRecipe(recipeId, Ingredient.m_43917_((JsonElement)json.getAsJsonObject("sapling")), CraftingHelper.getItemStack((JsonObject)json.getAsJsonObject("output"), (boolean)true), json.get("time").getAsInt(), ings.toArray(new Ingredient[0]));
        }

        @Nullable
        public TreeRitualRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            Ingredient[] ings = new Ingredient[buffer.readInt()];
            for (int i = 0; i < ings.length; ++i) {
                ings[i] = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            }
            return new TreeRitualRecipe(recipeId, Ingredient.m_43940_((FriendlyByteBuf)buffer), buffer.m_130267_(), buffer.readInt(), ings);
        }

        public void toNetwork(FriendlyByteBuf buffer, TreeRitualRecipe recipe) {
            buffer.writeInt(recipe.ingredients.length);
            for (Ingredient ing : recipe.ingredients) {
                ing.m_43923_(buffer);
            }
            recipe.saplingType.m_43923_(buffer);
            buffer.m_130055_(recipe.result);
            buffer.writeInt(recipe.time);
        }
    }
}

