/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.common.util.ITeleporter;

public class BlockDimensionRail
extends BaseRailBlock
implements IModItem,
ICustomBlockState,
ICustomItemModel {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61403_;
    private final String name;
    private final ResourceKey<Level> goalDim;
    private final ResourceKey<Level>[] canUseDims;

    @SafeVarargs
    public BlockDimensionRail(String name, ResourceKey<Level> goalDim, ResourceKey<Level> ... canUseDims) {
        super(false, BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50156_));
        this.name = name;
        this.goalDim = goalDim;
        this.canUseDims = canUseDims;
        ModRegistry.ALL_ITEMS.add(this);
    }

    private boolean canUseHere(ResourceKey<Level> dimension) {
        for (ResourceKey<Level> dim : this.canUseDims) {
            if (dim != dimension) continue;
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ModItems.RANGE_VISUALIZER) {
            if (!levelIn.f_46443_) {
                BlockPos goalPos = this.getGoalCoords(levelIn, pos);
                CompoundTag data = new CompoundTag();
                data.m_128359_("dim", this.goalDim.m_135782_().toString());
                data.m_128356_("pos", goalPos.m_121878_());
                PacketHandler.sendTo(player, new PacketClient(0, data));
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void onMinecartPass(BlockState state, Level level, BlockPos pos, AbstractMinecart cart) {
        if (level.f_46443_) {
            return;
        }
        if (!cart.m_20197_().isEmpty()) {
            return;
        }
        if (!this.canUseHere((ResourceKey<Level>)level.m_46472_())) {
            return;
        }
        AABB box = cart.m_20191_();
        PacketHandler.sendToAllAround(level, pos, 32, new PacketParticles((float)box.f_82288_, (float)box.f_82289_, (float)box.f_82290_, PacketParticles.Type.DIMENSION_RAIL, (int)((box.f_82291_ - box.f_82288_) * 100.0), (int)((box.f_82292_ - box.f_82289_) * 100.0), (int)((box.f_82293_ - box.f_82290_) * 100.0)));
        level.m_5594_(null, pos, SoundEvents.f_11852_, SoundSource.BLOCKS, 1.0f, 1.0f);
        final BlockPos goalCoords = this.getGoalCoords(level, pos);
        cart.changeDimension(level.m_7654_().m_129880_(this.goalDim), new ITeleporter(){

            public Entity placeEntity(Entity entity, ServerLevel currentLevel, ServerLevel destLevel, float yaw, Function<Boolean, Entity> repositionEntity) {
                entity.f_19853_.m_46473_().m_6182_("reloading");
                Entity result = entity.m_6095_().m_20615_((Level)destLevel);
                if (result != null) {
                    result.m_20361_(entity);
                    destLevel.m_143334_(result);
                    result.m_20035_(goalCoords, yaw, result.m_146909_());
                }
                return result;
            }
        });
        BlockPos spot = IAuraChunk.getHighestSpot(level, pos, 35, pos);
        IAuraChunk.getAuraChunk(level, spot).drainAura(spot, 50000);
    }

    private BlockPos getGoalCoords(Level level, BlockPos pos) {
        MinecraftServer server = level.m_7654_();
        if (this == ModBlocks.DIMENSION_RAIL_NETHER) {
            return new BlockPos(pos.m_123341_() / 8, pos.m_123342_() / 2, pos.m_123343_() / 8);
        }
        if (this == ModBlocks.DIMENSION_RAIL_END) {
            return ServerLevel.f_8562_.m_6630_(8);
        }
        if (level.m_46472_() == Level.f_46428_) {
            return new BlockPos(pos.m_123341_() * 8, pos.m_123342_() * 2, pos.m_123343_() * 8);
        }
        ServerLevel overworld = server.m_129880_(this.goalDim);
        BlockPos spawn = overworld.m_220360_();
        BlockPos ret = new BlockPos(spawn.m_123341_(), 0, spawn.m_123343_());
        return ret.m_6630_(overworld.m_6924_(Heightmap.Types.WORLD_SURFACE, spawn.m_123341_(), spawn.m_123343_()));
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }

    public boolean isFlexibleRail(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, BaseRailBlock.f_152149_});
    }

    @Override
    public String getBaseName() {
        return "dimension_rail_" + this.name;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/generated")).texture("layer0", "block/" + this.getBaseName());
    }
}

