/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemPetReviver
extends ItemImpl {
    public ItemPetReviver() {
        super("pet_reviver");
        MinecraftForge.EVENT_BUS.register((Object)new Events());
    }

    private static class Events {
        private Events() {
        }

        @SubscribeEvent
        public void onEntityTick(LivingEvent.LivingTickEvent event) {
            LivingEntity entity = event.getEntity();
            if (entity.f_19853_.f_46443_ || entity.f_19853_.m_46467_() % 20L != 0L || !(entity instanceof TamableAnimal)) {
                return;
            }
            TamableAnimal tameable = (TamableAnimal)entity;
            if (!tameable.m_21824_() || !tameable.getPersistentData().m_128471_("naturesaura:pet_reviver")) {
                return;
            }
            LivingEntity owner = tameable.m_21826_();
            if (owner == null || owner.m_20280_((Entity)tameable) > 25.0) {
                return;
            }
            if (entity.f_19853_.f_46441_.m_188501_() >= 0.65f) {
                ((ServerLevel)entity.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_() + entity.f_19853_.f_46441_.m_188583_() * 0.25, entity.m_20188_() + entity.f_19853_.f_46441_.m_188583_() * 0.25, entity.m_20189_() + entity.f_19853_.f_46441_.m_188583_() * 0.25, entity.f_19853_.f_46441_.m_188503_(2) + 1, 0.0, 0.0, 0.0, 0.0);
            }
        }

        @SubscribeEvent
        public void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
            Entity target = event.getTarget();
            if (!(target instanceof TamableAnimal) || !((TamableAnimal)target).m_21824_()) {
                return;
            }
            if (target.getPersistentData().m_128471_("naturesaura:pet_reviver")) {
                return;
            }
            ItemStack stack = event.getEntity().m_21120_(event.getHand());
            if (stack.m_41720_() != ModItems.PET_REVIVER) {
                return;
            }
            target.getPersistentData().m_128379_("naturesaura:pet_reviver", true);
            if (!target.f_19853_.f_46443_) {
                stack.m_41774_(1);
            }
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onLivingDeath(LivingDeathEvent event) {
            boolean b;
            float f;
            Optional bed;
            ServerPlayer player;
            BlockPos pos;
            LivingEntity entity = event.getEntity();
            if (entity.f_19853_.f_46443_ || !(entity instanceof TamableAnimal)) {
                return;
            }
            TamableAnimal tameable = (TamableAnimal)entity;
            if (!tameable.m_21824_() || !tameable.getPersistentData().m_128471_("naturesaura:pet_reviver")) {
                return;
            }
            ServerLevel spawnLevel = tameable.f_19853_.m_7654_().m_129783_();
            Vec3 spawn = Vec3.m_82539_((Vec3i)spawnLevel.m_220360_());
            LivingEntity owner = tameable.m_21826_();
            if (owner instanceof ServerPlayer && (pos = (player = (ServerPlayer)owner).m_8961_()) != null && (bed = Player.m_36130_((ServerLevel)((ServerLevel)player.f_19853_), (BlockPos)pos, (float)(f = player.m_8962_()), (boolean)(b = player.m_8964_()), (boolean)false)).isPresent()) {
                spawnLevel = (ServerLevel)player.f_19853_;
                spawn = (Vec3)bed.get();
            }
            PacketHandler.sendToAllAround(tameable.f_19853_, tameable.m_20183_(), 32, new PacketParticles((float)tameable.m_20185_(), (float)tameable.m_20188_(), (float)tameable.m_20189_(), PacketParticles.Type.PET_REVIVER, 12731933));
            TamableAnimal spawnedPet = tameable;
            if (tameable.f_19853_ != spawnLevel) {
                tameable.m_142687_(Entity.RemovalReason.DISCARDED);
                spawnedPet = (TamableAnimal)tameable.m_6095_().m_20615_((Level)spawnLevel);
            }
            spawnedPet.m_20361_((Entity)tameable);
            spawnedPet.m_20334_(0.0, 0.0, 0.0);
            spawnedPet.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, tameable.m_146908_(), tameable.m_146909_());
            while (!spawnLevel.m_45786_((Entity)spawnedPet)) {
                spawnedPet.m_6034_(spawnedPet.m_20185_(), spawnedPet.m_20186_() + 1.0, spawnedPet.m_20189_());
            }
            spawnedPet.m_21153_(spawnedPet.m_21233_());
            spawnedPet.m_21573_().m_26573_();
            spawnedPet.m_21837_(true);
            spawnedPet.m_6862_(false);
            spawnedPet.m_6710_(null);
            if (tameable.f_19853_ != spawnLevel) {
                spawnLevel.m_7967_((Entity)spawnedPet);
                tameable.m_142687_(Entity.RemovalReason.DISCARDED);
            }
            BlockPos auraPos = IAuraChunk.getHighestSpot((Level)spawnLevel, spawnedPet.m_20183_(), 35, spawnedPet.m_20183_());
            IAuraChunk.getAuraChunk((Level)spawnLevel, auraPos).drainAura(auraPos, 200000);
            PacketHandler.sendToAllAround(spawnedPet.f_19853_, spawnedPet.m_20183_(), 32, new PacketParticles((float)spawnedPet.m_20185_(), (float)spawnedPet.m_20188_(), (float)spawnedPet.m_20189_(), PacketParticles.Type.PET_REVIVER, 5093935));
            if (owner instanceof Player) {
                owner.m_213846_((Component)Component.m_237110_((String)"info.naturesaura.pet_reviver", (Object[])new Object[]{spawnedPet.m_5446_()}).m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
            event.setCanceled(true);
        }
    }
}

