/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.particles;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import java.util.Collections;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleMagic
extends Particle {
    public static final ResourceLocation TEXTURE = new ResourceLocation("naturesaura", "textures/particles/magic_round.png");
    private final float desiredScale;
    private final boolean fade;
    private final boolean depth;
    private float particleScale;

    public ParticleMagic(ClientLevel level, double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade, boolean depth) {
        super(level, posX, posY, posZ);
        this.desiredScale = scale;
        this.f_107225_ = maxAge;
        this.f_107219_ = collision;
        this.f_107226_ = gravity;
        this.fade = fade;
        this.depth = depth;
        this.f_107215_ = motionX;
        this.f_107216_ = motionY;
        this.f_107217_ = motionZ;
        float r = (float)(color >> 16 & 0xFF) / 255.0f * (1.0f - this.f_107223_.m_188501_() * 0.25f);
        float g = (float)(color >> 8 & 0xFF) / 255.0f * (1.0f - this.f_107223_.m_188501_() * 0.25f);
        float b = (float)(color & 0xFF) / 255.0f * (1.0f - this.f_107223_.m_188501_() * 0.25f);
        this.m_107253_(r, g, b);
        this.f_107230_ = 1.0f;
        this.particleScale = 0.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        ++this.f_107224_;
        if (this.f_107224_ > this.f_107225_) {
            this.m_107274_();
        } else {
            this.f_107216_ -= 0.04 * (double)this.f_107226_;
            this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
            float lifeRatio = (float)this.f_107224_ / (float)this.f_107225_;
            if (this.fade && lifeRatio > 0.75f) {
                this.f_107230_ = 1.0f - (lifeRatio - 0.75f) / 0.25f;
            }
            if (lifeRatio <= 0.25f) {
                this.particleScale = this.desiredScale * (lifeRatio / 0.25f);
            } else if (this.fade) {
                this.particleScale = this.desiredScale * (1.0f - (lifeRatio - 0.25f) / 0.75f);
            }
        }
    }

    public void m_6257_(double x, double y, double z) {
        double lastY = y;
        if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 motion = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, Collections.emptyList());
            x = motion.f_82479_;
            y = motion.f_82480_;
            z = motion.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        boolean bl = this.f_107218_ = lastY != y && lastY < 0.0;
        if (this.f_107218_) {
            this.f_107215_ = 0.0;
            this.f_107217_ = 0.0;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        Vec3 vec3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vec3d.f_82479_);
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vec3d.f_82480_);
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vec3d.f_82481_);
        Quaternion quaternion = renderInfo.m_90591_();
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        float f4 = 0.1f * this.particleScale;
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122251_(quaternion);
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
        }
        int j = this.m_6355_(partialTicks);
        buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(0.0f, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(1.0f, 1.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(1.0f, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(0.0f, 0.0f).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public ParticleRenderType m_7556_() {
        return this.depth ? ParticleHandler.MAGIC : ParticleHandler.MAGIC_NO_DEPTH;
    }

    protected int m_6355_(float p_107249_) {
        return 0xF000F0;
    }
}

