/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.monster.MagmaCube;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntitySlimeSplitGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int generationTimer;
    private int amountToRelease;
    private int color;

    public BlockEntitySlimeSplitGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SLIME_SPLIT_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (this.f_58857_.f_46443_ || this.f_58857_.m_46467_() % 10L != 0L) {
            return;
        }
        if (this.generationTimer > 0) {
            int amount = this.amountToRelease * 10;
            if (this.canGenerateRightNow(amount)) {
                this.generateAura(amount);
                PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles(this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), PacketParticles.Type.SLIME_SPLIT_GEN_CREATE, this.color));
            }
            this.generationTimer -= 10;
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    public boolean isBusy() {
        return this.generationTimer > 0;
    }

    public void startGenerating(Slime slime) {
        int size = slime.m_33632_();
        this.generationTimer = size * 30;
        this.amountToRelease = size * this.getGenerationAmount(slime) / this.generationTimer;
        this.color = this.getSlimeColor(slime);
        PacketHandler.sendToAllAround(this.f_58857_, this.f_58858_, 32, new PacketParticles((float)slime.m_20185_(), (float)slime.m_20186_(), (float)slime.m_20189_(), PacketParticles.Type.SLIME_SPLIT_GEN_START, this.f_58858_.m_123341_(), this.f_58858_.m_123342_(), this.f_58858_.m_123343_(), this.color));
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.m_128405_("timer", this.generationTimer);
            compound.m_128405_("amount", this.amountToRelease);
            compound.m_128405_("color", this.color);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.generationTimer = compound.m_128451_("timer");
            this.amountToRelease = compound.m_128451_("amount");
            this.color = compound.m_128451_("color");
        }
    }

    private int getSlimeColor(Slime slime) {
        if (slime instanceof MagmaCube) {
            return 9708822;
        }
        return 5089359;
    }

    private int getGenerationAmount(Slime slime) {
        if (slime instanceof MagmaCube) {
            return 45000;
        }
        return 25000;
    }
}

