/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.potion.ModPotions;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;

public class BreathlessEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "breathless");
    private int amp;
    private AABB bb;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(level, pos, 50);
        if (aura > 0) {
            return false;
        }
        int dist = Math.min(Math.abs(aura) / 50000, 75);
        if (dist < 10) {
            return false;
        }
        this.amp = Math.min(Mth.m_14143_((float)((float)Math.abs(aura) / 2500000.0f)), 3);
        this.bb = new AABB(pos).m_82400_((double)dist);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.m_9236_(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!this.bb.m_82390_(player.m_146892_())) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Blocks.f_50041_);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (level.m_46467_() % 100L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        List entities = level.m_45976_(LivingEntity.class, this.bb);
        for (LivingEntity entity : entities) {
            entity.m_7292_(new MobEffectInstance(ModPotions.BREATHLESS, 300, this.amp));
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.breathlessEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

