/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;

public class GrassDieEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "grass_die");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        Pair<Integer, Integer> auraAndSpots;
        int aura;
        if (spot < 0 && (aura = ((Integer)(auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 50)).getLeft()).intValue()) < 0) {
            this.amount = Math.min(300, Mth.m_14167_((float)((float)Math.abs(aura) / 100000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
            if (this.amount > 1) {
                this.dist = Mth.m_14045_((int)(Math.abs(aura) / 75000), (int)5, (int)75);
                return true;
            }
        }
        return false;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.m_9236_(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.m_20275_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)ModBlocks.DECAYED_LEAVES);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + level.f_46441_.m_188503_(this.amount / 2); i >= 0; --i) {
            BlockPos grassPos = BlockPos.m_274561_((double)((double)pos.m_123341_() + level.f_46441_.m_188583_() * (double)this.dist), (double)((double)pos.m_123342_() + level.f_46441_.m_188583_() * (double)this.dist), (double)((double)pos.m_123343_() + level.f_46441_.m_188583_() * (double)this.dist));
            if (!(grassPos.m_123331_((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.m_46749_(grassPos)) continue;
            BlockState state = level.m_8055_(grassPos);
            Block block = state.m_60734_();
            BlockState newState = null;
            if (block instanceof LeavesBlock) {
                newState = ModBlocks.DECAYED_LEAVES.m_49966_();
            } else if (block instanceof GrassBlock) {
                newState = Blocks.f_50546_.m_49966_();
            } else if (block instanceof BushBlock) {
                newState = Blocks.f_50016_.m_49966_();
            } else if (block == ModBlocks.NETHER_GRASS) {
                newState = Blocks.f_50134_.m_49966_();
            }
            if (newState == null) continue;
            level.m_46597_(grassPos, newState);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.grassDieEffect.get() != false && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

