/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.jei;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.compat.jei.AltarCategory;
import de.ellpeck.naturesaura.compat.jei.AnimalSpawnerCategory;
import de.ellpeck.naturesaura.compat.jei.OfferingCategory;
import de.ellpeck.naturesaura.compat.jei.TreeRitualCategory;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.recipes.AltarRecipe;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import de.ellpeck.naturesaura.recipes.OfferingRecipe;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;

@JeiPlugin
public class JEINaturesAuraPlugin
implements IModPlugin {
    public static final RecipeType<TreeRitualRecipe> TREE_RITUAL = RecipeType.create((String)"naturesaura", (String)"tree_ritual", TreeRitualRecipe.class);
    public static final RecipeType<AltarRecipe> ALTAR = RecipeType.create((String)"naturesaura", (String)"altar", AltarRecipe.class);
    public static final RecipeType<OfferingRecipe> OFFERING = RecipeType.create((String)"naturesaura", (String)"offering", OfferingRecipe.class);
    public static final RecipeType<AnimalSpawnerRecipe> SPAWNER = RecipeType.create((String)"naturesaura", (String)"animal_spawner", AnimalSpawnerRecipe.class);

    public ResourceLocation getPluginUid() {
        return new ResourceLocation("naturesaura", "jei_plugin");
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper helper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new TreeRitualCategory(helper), new AltarCategory(helper), new OfferingCategory(helper), new AnimalSpawnerCategory(helper)});
    }

    public void registerItemSubtypes(ISubtypeRegistration registration) {
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.EFFECT_POWDER, (stack, context) -> ItemEffectPowder.getEffect(stack).toString());
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.AURA_BOTTLE, (stack, context) -> ItemAuraBottle.getType(stack).getName().toString());
        IIngredientSubtypeInterpreter auraInterpreter = (stack, context) -> {
            IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.CAP_AURA_CONTAINER).orElse(null);
            if (container != null) {
                return String.valueOf(container.getStoredAura());
            }
            return "";
        };
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.AURA_CACHE, auraInterpreter);
        registration.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ModItems.AURA_TROVE, auraInterpreter);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.GOLD_POWDER), new RecipeType[]{TREE_RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WOOD_STAND), new RecipeType[]{TREE_RITUAL});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.NATURE_ALTAR), new RecipeType[]{ALTAR});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.OFFERING_TABLE), new RecipeType[]{OFFERING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.ANIMAL_SPAWNER), new RecipeType[]{SPAWNER});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager manager = Minecraft.m_91087_().f_91073_.m_7465_();
        registration.addRecipes(TREE_RITUAL, manager.m_44013_(ModRecipes.TREE_RITUAL_TYPE));
        registration.addRecipes(ALTAR, manager.m_44013_(ModRecipes.ALTAR_TYPE));
        registration.addRecipes(OFFERING, manager.m_44013_(ModRecipes.OFFERING_TYPE));
        registration.addRecipes(SPAWNER, manager.m_44013_(ModRecipes.ANIMAL_SPAWNER_TYPE));
    }
}

