/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura;

import com.google.common.base.Strings;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.chunk.effect.DrainSpotEffects;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.events.CommonEvents;
import de.ellpeck.naturesaura.proxy.ClientProxy;
import de.ellpeck.naturesaura.proxy.IProxy;
import de.ellpeck.naturesaura.proxy.ServerProxy;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="naturesaura")
public final class NaturesAura {
    public static final String MOD_ID = "naturesaura";
    public static final String MOD_NAME = "Nature's Aura";
    public static final Logger LOGGER = LogManager.getLogger((String)"Nature's Aura");
    public static NaturesAura instance;
    public static IProxy proxy;

    public NaturesAura(IEventBus eventBus) {
        instance = this;
        proxy = FMLEnvironment.dist.isClient() ? new ClientProxy() : new ServerProxy();
        eventBus.addListener(this::setup);
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        ModConfig.instance = new ModConfig(builder);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)builder.build());
    }

    public void setup(FMLCommonSetupEvent event) {
        this.preInit(event);
        this.init(event);
        this.postInit(event);
    }

    private void preInit(FMLCommonSetupEvent event) {
        Compat.setup(event);
        new Multiblocks();
        NeoForge.EVENT_BUS.register((Object)new CommonEvents());
        proxy.preInit(event);
    }

    private void init(FMLCommonSetupEvent event) {
        event.enqueueWork(ModConfig.instance::apply);
        ModRecipes.init();
        DrainSpotEffects.init();
        proxy.init(event);
    }

    private void postInit(FMLCommonSetupEvent event) {
        proxy.postInit(event);
        LOGGER.info("-- Nature's Aura Fake Player Information --");
        LOGGER.info("Name: [Minecraft]");
        LOGGER.info("UUID: 41C82C87-7AfB-4024-BA57-13D2C99CAE77");
        LOGGER.info(Strings.padStart((String)"", (int)43, (char)'-'));
    }
}

