/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.api.aura.chunk;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.util.INBTSerializable;
import org.apache.commons.lang3.tuple.Pair;

public interface IAuraChunk
extends INBTSerializable<CompoundTag> {
    public static final int DEFAULT_AURA = 1000000;

    public static IAuraChunk getAuraChunk(Level level, BlockPos pos) {
        LevelChunk chunk = (LevelChunk)level.getChunk(pos);
        return (IAuraChunk)chunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT);
    }

    public static void getSpotsInArea(Level level, BlockPos pos, int radius, BiConsumer<BlockPos, Integer> consumer) {
        NaturesAuraAPI.instance().getAuraSpotsInArea(level, pos, radius, consumer);
    }

    public static int getSpotAmountInArea(Level level, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getSpotAmountInArea(level, pos, radius);
    }

    public static int getAuraInArea(Level level, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getAuraInArea(level, pos, radius);
    }

    public static Pair<Integer, Integer> getAuraAndSpotAmountInArea(Level level, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().getAuraAndSpotAmountInArea(level, pos, radius);
    }

    public static int triangulateAuraInArea(Level level, BlockPos pos, int radius) {
        return NaturesAuraAPI.instance().triangulateAuraInArea(level, pos, radius);
    }

    public static BlockPos getLowestSpot(Level level, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getLowestAuraDrainSpot(level, pos, radius, defaultSpot);
    }

    public static BlockPos getHighestSpot(Level level, BlockPos pos, int radius, BlockPos defaultSpot) {
        return NaturesAuraAPI.instance().getHighestAuraDrainSpot(level, pos, radius, defaultSpot);
    }

    public int drainAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int drainAura(BlockPos var1, int var2);

    public int storeAura(BlockPos var1, int var2, boolean var3, boolean var4);

    public int storeAura(BlockPos var1, int var2);

    public AuraChunk.DrainSpot getActualDrainSpot(BlockPos var1, boolean var2);

    public int getDrainSpot(BlockPos var1);

    public IAuraType getType();

    public void markDirty();
}

