/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityFieldCreator;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.model.generators.ModelFile;

public class BlockFieldCreator
extends BlockContainerImpl
implements ICustomBlockState {
    public BlockFieldCreator() {
        super("field_creator", BlockEntityFieldCreator.class, BlockBehaviour.Properties.of().strength(2.0f).noOcclusion().sound(SoundType.STONE));
    }

    public InteractionResult use(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        BlockEntity tile = levelIn.getBlockEntity(pos);
        if (tile instanceof BlockEntityFieldCreator) {
            if (!levelIn.isClientSide) {
                String key = "naturesaura:field_creator_pos";
                CompoundTag compound = player.getPersistentData();
                if (!player.isShiftKeyDown() && compound.contains(key)) {
                    BlockPos stored = BlockPos.of((long)compound.getLong(key));
                    BlockEntityFieldCreator creator = (BlockEntityFieldCreator)tile;
                    if (!pos.equals((Object)stored)) {
                        if (creator.isCloseEnough(stored)) {
                            BlockEntity otherTile = levelIn.getBlockEntity(stored);
                            if (otherTile instanceof BlockEntityFieldCreator) {
                                BlockEntityFieldCreator otherCreator = (BlockEntityFieldCreator)otherTile;
                                creator.connectionOffset = stored.subtract((Vec3i)pos);
                                creator.isMain = true;
                                creator.sendToClients();
                                otherCreator.connectionOffset = pos.subtract((Vec3i)stored);
                                otherCreator.isMain = false;
                                otherCreator.sendToClients();
                                compound.remove(key);
                                player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.connected"), true);
                            } else {
                                player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.stored_pos_gone"), true);
                            }
                        } else {
                            player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.too_far"), true);
                        }
                    } else {
                        player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.same_position"), true);
                    }
                } else {
                    compound.putLong(key, pos.asLong());
                    player.displayClientMessage((Component)Component.translatable((String)"info.naturesaura.stored_pos"), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(BlockState stateIn, Level levelIn, BlockPos pos, RandomSource rand) {
        BlockEntity tile = levelIn.getBlockEntity(pos);
        if (tile instanceof BlockEntityFieldCreator) {
            BlockPos connected;
            BlockEntityFieldCreator creator = (BlockEntityFieldCreator)tile;
            if (creator.isCharged && (connected = creator.getConnectedPos()) != null) {
                NaturesAuraAPI.instance().spawnParticleStream((float)pos.getX() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.getY() + 0.25f + rand.nextFloat() * 0.5f, (float)pos.getZ() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.getX() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.getY() + 0.25f + rand.nextFloat() * 0.5f, (float)connected.getZ() + 0.25f + rand.nextFloat() * 0.5f, 0.65f, 4343284, 1.0f);
            }
        }
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

