/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityPickupStopper;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.AABB;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.EntityItemPickupEvent;

public class BlockPickupStopper
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    public BlockPickupStopper() {
        super("pickup_stopper", BlockEntityPickupStopper.class, BlockBehaviour.Properties.of().strength(2.0f).sound(SoundType.STONE));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (player != null && !player.isShiftKeyDown()) {
            ItemEntity item = event.getItem();
            BlockPos pos = item.blockPosition();
            Helper.getBlockEntitiesInArea((LevelAccessor)item.level(), pos, 8, tile -> {
                if (!(tile instanceof BlockEntityPickupStopper)) {
                    return false;
                }
                BlockEntityPickupStopper stopper = (BlockEntityPickupStopper)((Object)tile);
                float radius = stopper.getRadius();
                if (radius <= 0.0f) {
                    return false;
                }
                BlockPos stopperPos = stopper.getBlockPos();
                if (!new AABB(stopperPos).inflate((double)radius).intersects(item.getBoundingBox())) {
                    return false;
                }
                event.setCanceled(true);
                if (item.level().getGameTime() % 3L == 0L) {
                    PacketHandler.sendToAllAround(item.level(), pos, 32, new PacketParticles((float)item.getX(), (float)item.getY(), (float)item.getZ(), PacketParticles.Type.PICKUP_STOPPER, new int[0]));
                }
                return true;
            });
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        double radius;
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof BlockEntityPickupStopper && (radius = (double)((BlockEntityPickupStopper)tile).getRadius()) > 0.0) {
            return new AABB(pos).inflate(radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 16034370;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().cubeBottomTop(this.getBaseName(), generator.modLoc("block/" + this.getBaseName()), generator.modLoc("block/" + this.getBaseName() + "_top"), generator.modLoc("block/" + this.getBaseName() + "_top")));
    }
}

