/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySpawnLamp;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;

public class BlockSpawnLamp
extends BlockContainerImpl
implements IVisualizable,
ICustomBlockState {
    private static final VoxelShape SHAPE = Shapes.create((double)0.25, (double)0.0, (double)0.25, (double)0.75, (double)0.8125, (double)0.75);

    public BlockSpawnLamp() {
        super("spawn_lamp", BlockEntitySpawnLamp.class, BlockBehaviour.Properties.of().strength(3.0f).lightLevel(s -> 15).sound(SoundType.METAL));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    @SubscribeEvent
    public void onSpawn(MobSpawnEvent.PositionCheck event) {
        int amountToUse = 200;
        if (event.getSpawner() != null) {
            return;
        }
        ServerLevelAccessor accessor = event.getLevel();
        BlockPos pos = BlockPos.containing((double)event.getX(), (double)event.getY(), (double)event.getZ());
        if (!(accessor instanceof Level)) {
            return;
        }
        Level level = (Level)accessor;
        LevelData data = (LevelData)ILevelData.getLevelData(level);
        for (BlockEntitySpawnLamp lamp : data.spawnLamps) {
            BlockPos lampPos;
            int range;
            if (lamp.isRemoved() || !lamp.canUseRightNow(amountToUse) || (range = lamp.getRadius()) <= 0 || !new AABB(lampPos = lamp.getBlockPos()).inflate((double)range).contains(new Vec3((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5))) continue;
            Mob entity = event.getEntity();
            if (entity.checkSpawnRules((LevelAccessor)level, event.getSpawnType()) && entity.checkSpawnObstruction((LevelReader)level)) {
                BlockPos spot = IAuraChunk.getHighestSpot(level, lampPos, 32, lampPos);
                IAuraChunk.getAuraChunk(level, spot).drainAura(spot, amountToUse);
                PacketHandler.sendToAllAround(level, lampPos, 32, new PacketParticles(lampPos.getX(), lampPos.getY(), lampPos.getZ(), PacketParticles.Type.SPAWN_LAMP, new int[0]));
            }
            event.setResult(Event.Result.DENY);
            break;
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        int radius;
        BlockEntity tile = level.getBlockEntity(pos);
        if (tile instanceof BlockEntitySpawnLamp && (radius = ((BlockEntitySpawnLamp)tile).getRadius()) > 0) {
            return new AABB(pos).inflate((double)radius);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return 8543973;
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }
}

