/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.multiblock.Matcher;
import de.ellpeck.naturesaura.blocks.BlockContainerImpl;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityWoodStand;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.blocks.tiles.render.RenderWoodStand;
import de.ellpeck.naturesaura.data.BlockStateGenerator;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import de.ellpeck.naturesaura.reg.ICustomBlockState;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.level.SaplingGrowTreeEvent;
import org.apache.commons.lang3.mutable.MutableObject;

public class BlockWoodStand
extends BlockContainerImpl
implements ITESRProvider<BlockEntityWoodStand>,
ICustomBlockState {
    private static final VoxelShape SHAPE = Shapes.create((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.8125, (double)0.8125);

    public BlockWoodStand() {
        super("wood_stand", BlockEntityWoodStand.class, BlockBehaviour.Properties.of().strength(1.5f).sound(SoundType.WOOD));
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @Override
    protected boolean hasWaterlogging() {
        return true;
    }

    public VoxelShape getShape(BlockState state, BlockGetter levelIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @SubscribeEvent
    public void onTreeGrow(SaplingGrowTreeEvent event) {
        ItemStack saplingStack;
        LevelAccessor level = event.getLevel();
        BlockPos pos = event.getPos();
        if (!level.isClientSide() && level instanceof Level && Multiblocks.TREE_RITUAL.isComplete((Level)level, pos) && !(saplingStack = new ItemStack((ItemLike)level.getBlockState(pos).getBlock())).isEmpty()) {
            for (RecipeHolder recipe : ((Level)level).getRecipeManager().getRecipesFor(ModRecipes.TREE_RITUAL_TYPE, null, (Level)level)) {
                MutableObject toPick;
                ArrayList<Ingredient> required;
                boolean fine;
                if (!((TreeRitualRecipe)recipe.value()).saplingType.test(saplingStack) || !(fine = Multiblocks.TREE_RITUAL.forEach(pos, 'W', (arg_0, arg_1) -> BlockWoodStand.lambda$onTreeGrow$0(level, required = new ArrayList<Ingredient>(((TreeRitualRecipe)recipe.value()).ingredients), toPick = new MutableObject(), arg_0, arg_1))) || !required.isEmpty()) continue;
                ((BlockEntityWoodStand)toPick.getValue()).setRitual(pos, (RecipeHolder<TreeRitualRecipe>)recipe);
                break;
            }
        }
    }

    public InteractionResult use(BlockState state, Level levelIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        return Helper.putStackOnTile(player, handIn, pos, 0, true);
    }

    @Override
    public void generateCustomBlockState(BlockStateGenerator generator) {
        generator.simpleBlock((Block)this, (ModelFile)generator.models().getExistingFile(generator.modLoc(this.getBaseName())));
    }

    @Override
    public void registerTESR() {
        BlockEntityRenderers.register(ModBlockEntities.WOOD_STAND, RenderWoodStand::new);
    }

    private static /* synthetic */ Boolean lambda$onTreeGrow$0(LevelAccessor level, List required, MutableObject toPick, BlockPos tilePos, Matcher matcher) {
        BlockEntity tile = level.getBlockEntity(tilePos);
        if (tile instanceof BlockEntityWoodStand) {
            BlockEntityWoodStand stand = (BlockEntityWoodStand)tile;
            ItemStack stack = stand.items.getStackInSlot(0);
            if (!stack.isEmpty()) {
                for (int i = required.size() - 1; i >= 0; --i) {
                    Ingredient req = (Ingredient)required.get(i);
                    if (!req.test(stack)) continue;
                    required.remove(i);
                    if (toPick.getValue() == null) {
                        toPick.setValue((Object)stand);
                    }
                    return true;
                }
                return false;
            }
        }
        return true;
    }
}

