/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityAuraBloom
extends BlockEntityImpl
implements ITickableBlockEntity {
    public boolean justGenerated;

    public BlockEntityAuraBloom(BlockPos pos, BlockState state) {
        this(ModBlockEntities.AURA_BLOOM, pos, state);
    }

    protected BlockEntityAuraBloom(BlockEntityType<BlockEntityAuraBloom> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide || !this.justGenerated) {
            return;
        }
        this.generateAura(150000);
        this.justGenerated = false;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.putBoolean("just_generated", this.justGenerated);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.justGenerated = compound.getBoolean("just_generated");
        }
    }
}

