/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityFurnaceHeater;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlastFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public class BlockEntityBlastFurnaceBooster
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityBlastFurnaceBooster(BlockPos pos, BlockState state) {
        super(ModBlockEntities.BLAST_FURNACE_BOOSTER, pos, state);
    }

    @Override
    public void tick() {
        if (this.level.isClientSide) {
            return;
        }
        int toUse = 6500;
        if (!this.canUseRightNow(toUse)) {
            return;
        }
        BlockEntity below = this.level.getBlockEntity(this.worldPosition.below());
        if (!(below instanceof BlastFurnaceBlockEntity)) {
            return;
        }
        BlastFurnaceBlockEntity tile = (BlastFurnaceBlockEntity)below;
        Recipe recipe = ((RecipeHolder)this.level.getRecipeManager().getRecipeFor(BlockEntityFurnaceHeater.getRecipeType((AbstractFurnaceBlockEntity)tile), (Container)tile, this.level).orElse(null)).value();
        if (recipe == null) {
            return;
        }
        if (!this.isApplicable((List<Ingredient>)recipe.getIngredients())) {
            return;
        }
        ContainerData data = BlockEntityFurnaceHeater.getFurnaceData((AbstractFurnaceBlockEntity)tile);
        int doneDiff = data.get(3) - data.get(2);
        if (doneDiff > 1) {
            return;
        }
        if (this.level.random.nextFloat() > 0.45f) {
            PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.BLAST_FURNACE_BOOSTER, 0));
            return;
        }
        ItemStack output = tile.getItem(2);
        if (output.getCount() >= output.getMaxStackSize()) {
            return;
        }
        if (output.isEmpty()) {
            ItemStack result = recipe.getResultItem(this.level.registryAccess());
            tile.setItem(2, result.copy());
        } else {
            output.grow(1);
        }
        BlockPos pos = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 30, this.worldPosition);
        IAuraChunk.getAuraChunk(this.level, pos).drainAura(pos, toUse);
        PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.BLAST_FURNACE_BOOSTER, 1));
    }

    private boolean isApplicable(List<Ingredient> ingredients) {
        for (Ingredient ing : ingredients) {
            for (ItemStack stack : ing.getItems()) {
                if (!stack.is(Tags.Items.ORES) && !stack.is(Tags.Items.RAW_MATERIALS)) continue;
                return true;
            }
        }
        return false;
    }

    public IItemHandlerModifiable getItemHandler() {
        BlockEntity below = this.level.getBlockEntity(this.worldPosition.below());
        if (!(below instanceof BlastFurnaceBlockEntity)) {
            return null;
        }
        final IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, below.getBlockPos(), below.getBlockState(), below, (Object)Direction.UP);
        if (handler == null) {
            return null;
        }
        return new IItemHandlerModifiable(){

            public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
                if (handler instanceof IItemHandlerModifiable) {
                    ((IItemHandlerModifiable)handler).setStackInSlot(0, stack);
                }
            }

            public int getSlots() {
                return 1;
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                return handler.getStackInSlot(0);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                return handler.insertItem(0, stack, simulate);
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return handler.extractItem(0, amount, simulate);
            }

            public int getSlotLimit(int slot) {
                return handler.getSlotLimit(0);
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return handler.isItemValid(0, stack);
            }
        };
    }

    @Override
    public void dropInventory() {
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

