/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlockEntityFlowerGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private final Map<BlockState, MutableInt> consumedRecently = new HashMap<BlockState, MutableInt>();

    public BlockEntityFlowerGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.FLOWER_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L) {
            ArrayList<BlockPos> possible = new ArrayList<BlockPos>();
            int range = 3;
            for (int x = -range; x <= range; ++x) {
                for (int y = -1; y <= 1; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = this.worldPosition.offset(x, y, z);
                        BlockState state = this.level.getBlockState(offset);
                        if (!state.is(BlockTags.SMALL_FLOWERS)) continue;
                        possible.add(offset);
                    }
                }
            }
            if (possible.isEmpty()) {
                return;
            }
            int addAmount = 25000;
            BlockPos pos = (BlockPos)possible.get(this.level.random.nextInt(possible.size()));
            BlockState state = this.level.getBlockState(pos);
            MutableInt curr = this.consumedRecently.computeIfAbsent(state, s -> new MutableInt());
            int toAdd = Math.max(0, addAmount - curr.getValue() * 100);
            if (toAdd > 0) {
                if (IAuraType.forLevel(this.level).isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) && this.canGenerateRightNow(toAdd)) {
                    this.generateAura(toAdd);
                } else {
                    toAdd = 0;
                }
            }
            for (Map.Entry<BlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                MutableInt val;
                if (entry.getKey() == state || (val = entry.getValue()).getValue() <= 0) continue;
                val.subtract(1);
            }
            curr.add(5);
            this.level.removeBlock(pos, false);
            int color = Helper.blendColors(6081584, 15023126, (float)toAdd / (float)addAmount);
            if (toAdd > 0) {
                for (int i = this.level.random.nextInt(5) + 5; i >= 0; --i) {
                    PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticleStream((float)pos.getX() + 0.25f + this.level.random.nextFloat() * 0.5f, (float)pos.getY() + 0.25f + this.level.random.nextFloat() * 0.5f, (float)pos.getZ() + 0.25f + this.level.random.nextFloat() * 0.5f, (float)this.worldPosition.getX() + 0.25f + this.level.random.nextFloat() * 0.5f, (float)this.worldPosition.getY() + 0.25f + this.level.random.nextFloat() * 0.5f, (float)this.worldPosition.getZ() + 0.25f + this.level.random.nextFloat() * 0.5f, this.level.random.nextFloat() * 0.02f + 0.1f, color, 1.0f));
                }
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.FLOWER_GEN_AURA_CREATION, new int[0]));
            }
            PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(pos.getX(), pos.getY(), pos.getZ(), PacketParticles.Type.FLOWER_GEN_CONSUME, color));
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.SYNC && !this.consumedRecently.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<BlockState, MutableInt> entry : this.consumedRecently.entrySet()) {
                BlockState state = entry.getKey();
                Block block = state.getBlock();
                CompoundTag tag = new CompoundTag();
                tag.putString("block", BuiltInRegistries.BLOCK.getKey((Object)block).toString());
                tag.putInt("amount", entry.getValue().intValue());
                list.add((Object)tag);
            }
            compound.put("consumed_recently", (Tag)list);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.SYNC) {
            this.consumedRecently.clear();
            ListTag list = compound.getList("consumed_recently", 10);
            for (Tag base : list) {
                CompoundTag tag = (CompoundTag)base;
                Block block = (Block)BuiltInRegistries.BLOCK.get(new ResourceLocation(tag.getString("block")));
                if (block == null) continue;
                this.consumedRecently.put(block.defaultBlockState(), new MutableInt(tag.getInt("amount")));
            }
        }
    }
}

