/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockEntityHopperUpgrade
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityHopperUpgrade(BlockPos pos, BlockState state) {
        super(ModBlockEntities.HOPPER_UPGRADE, pos, state);
    }

    private static boolean isValidHopper(BlockEntity tile) {
        if (tile instanceof HopperBlockEntity) {
            return (Boolean)tile.getLevel().getBlockState(tile.getBlockPos()).getValue((Property)HopperBlock.ENABLED);
        }
        if (tile instanceof BlockEntityGratedChute) {
            return ((BlockEntityGratedChute)tile).redstonePower <= 0;
        }
        return false;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L) {
            if (IAuraChunk.getAuraInArea(this.level, this.worldPosition, 25) < 100000) {
                return;
            }
            BlockEntity tile = this.level.getBlockEntity(this.worldPosition.below());
            if (!BlockEntityHopperUpgrade.isValidHopper(tile)) {
                return;
            }
            IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, (Object)Direction.UP);
            if (handler == null) {
                return;
            }
            List items = this.level.getEntitiesOfClass(ItemEntity.class, new AABB(this.worldPosition).inflate(7.0));
            if (items.isEmpty()) {
                return;
            }
            int drainPerItem = 500;
            if (!this.canUseRightNow(drainPerItem * items.size())) {
                return;
            }
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.isAlive() || item.hasPickUpDelay() || (stack = item.getItem()).isEmpty()) continue;
                ItemStack copy = stack.copy();
                for (int i = 0; i < handler.getSlots() && !(copy = handler.insertItem(i, copy, false)).isEmpty(); ++i) {
                }
                if (ItemStack.matches((ItemStack)stack, (ItemStack)copy)) continue;
                item.setItem(copy);
                if (copy.isEmpty()) {
                    item.kill();
                }
                BlockPos spot = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 25, this.worldPosition);
                IAuraChunk.getAuraChunk(this.level, spot).drainAura(spot, drainPerItem);
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)item.getX(), (float)item.getY(), (float)item.getZ(), PacketParticles.Type.HOPPER_UPGRADE, new int[0]));
            }
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

