/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockEntityImpl
extends BlockEntity {
    public int redstonePower;

    public BlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void saveAdditional(CompoundTag compound) {
        this.writeNBT(compound, SaveType.TILE);
    }

    public void load(CompoundTag compound) {
        this.readNBT(compound, SaveType.TILE);
    }

    public void writeNBT(CompoundTag compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.saveAdditional(compound);
            compound.putInt("redstone", this.redstonePower);
        }
    }

    public void readNBT(CompoundTag compound, SaveType type) {
        if (type != SaveType.BLOCK) {
            super.load(compound);
            this.redstonePower = compound.getInt("redstone");
        }
    }

    public void onRedstonePowerChange(int newPower) {
        this.redstonePower = newPower;
    }

    public final ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this, e -> {
            CompoundTag compound = new CompoundTag();
            this.writeNBT(compound, SaveType.SYNC);
            return compound;
        });
    }

    public final CompoundTag getUpdateTag() {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound, SaveType.SYNC);
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readNBT(tag, SaveType.SYNC);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.readNBT(pkt.getTag(), SaveType.SYNC);
    }

    public void sendToClients() {
        ServerLevel world = (ServerLevel)this.getLevel();
        List entities = world.getChunkSource().chunkMap.getPlayers(new ChunkPos(this.getBlockPos()), false);
        ClientboundBlockEntityDataPacket packet = this.getUpdatePacket();
        for (ServerPlayer e : entities) {
            e.connection.send((Packet)packet);
        }
    }

    public void dropInventory() {
        IItemHandler handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, this.worldPosition, this.getBlockState(), (BlockEntity)this, null);
        if (handler != null) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                ItemStack stack = handler.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                ItemEntity item = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
                this.level.addFreshEntity((Entity)item);
            }
        }
    }

    public void modifyDrop(ItemStack regularItem) {
        CompoundTag compound = new CompoundTag();
        this.writeNBT(compound, SaveType.BLOCK);
        if (!compound.isEmpty()) {
            if (!regularItem.hasTag()) {
                regularItem.setTag(new CompoundTag());
            }
            regularItem.getTag().put("data", (Tag)compound);
        }
    }

    public void loadDataOnPlace(ItemStack stack) {
        CompoundTag compound;
        if (stack.hasTag() && (compound = stack.getTag().getCompound("data")) != null) {
            this.readNBT(compound, SaveType.BLOCK);
        }
    }

    public boolean canUseRightNow(int toUse) {
        if (this.allowsLowerLimiter()) {
            for (Direction dir : Direction.values()) {
                BlockPos offset = this.worldPosition.relative(dir);
                if (this.level.getBlockState(offset).getBlock() != ModBlocks.LOWER_LIMITER) continue;
                int aura = IAuraChunk.getAuraInArea(this.level, this.worldPosition, 35);
                return aura - toUse > 0;
            }
        }
        return true;
    }

    public boolean canGenerateRightNow(int toAdd) {
        BlockState below;
        if (this.wantsLimitRemover() && (below = this.level.getBlockState(this.worldPosition.below())).getBlock() == ModBlocks.GENERATOR_LIMIT_REMOVER) {
            return true;
        }
        int aura = IAuraChunk.getAuraInArea(this.level, this.worldPosition, 35);
        return aura + toAdd <= 2000000;
    }

    public boolean wantsLimitRemover() {
        return false;
    }

    public boolean allowsLowerLimiter() {
        return false;
    }

    public void generateAura(int amount) {
        while (amount > 0) {
            BlockPos spot = IAuraChunk.getLowestSpot(this.level, this.worldPosition, 35, this.worldPosition);
            amount -= IAuraChunk.getAuraChunk(this.level, spot).storeAura(spot, amount);
        }
    }

    public static enum SaveType {
        TILE,
        SYNC,
        BLOCK;

    }
}

