/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.state.BlockState;

public class BlockEntityOakGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public Queue<BlockPos> scheduledBigTrees = new ArrayDeque<BlockPos>();

    public BlockEntityOakGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.OAK_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide) {
            while (!this.scheduledBigTrees.isEmpty()) {
                BlockPos pos = this.scheduledBigTrees.remove();
                if (!this.level.getBlockState(pos).is(BlockTags.LOGS)) continue;
                int toAdd = 100000;
                boolean canGen = this.canGenerateRightNow(toAdd);
                if (canGen) {
                    this.generateAura(toAdd);
                }
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.OAK_GENERATOR, pos.getX(), pos.getY(), pos.getZ(), canGen ? 1 : 0));
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

