/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class BlockEntityPotionGenerator
extends BlockEntityImpl
implements ITickableBlockEntity {
    public BlockEntityPotionGenerator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.POTION_GENERATOR, pos, state);
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.level.getGameTime() % 10L == 0L && Multiblocks.POTION_GENERATOR.isComplete(this.level, this.worldPosition)) {
            boolean addedOne = false;
            List clouds = this.level.getEntitiesOfClass(AreaEffectCloud.class, new AABB(this.worldPosition).inflate(2.0));
            for (AreaEffectCloud cloud : clouds) {
                float newRadius;
                if (!cloud.isAlive()) continue;
                if (!addedOne) {
                    Potion type = cloud.getPotion();
                    if (type == null) continue;
                    for (MobEffectInstance effect : type.getEffects()) {
                        MobEffect potion = effect.getEffect();
                        if (!potion.isBeneficial() || potion.isInstantenous()) continue;
                        int toAdd = (effect.getAmplifier() * 7 + 1) * (effect.getDuration() / 25) * 100;
                        boolean canGen = this.canGenerateRightNow(toAdd);
                        if (canGen) {
                            this.generateAura(toAdd);
                        }
                        PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.POTION_GEN, PotionUtils.getColor((Potion)type), canGen ? 1 : 0));
                        addedOne = true;
                        break;
                    }
                }
                if ((newRadius = cloud.getRadius() - 0.25f) < 0.5f) {
                    cloud.kill();
                    continue;
                }
                cloud.setRadius(newRadius);
            }
        }
    }

    @Override
    public boolean wantsLimitRemover() {
        return true;
    }
}

