/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class BlockEntityPowderPlacer
extends BlockEntityImpl {
    public BlockEntityPowderPlacer(BlockPos pos, BlockState state) {
        super(ModBlockEntities.POWDER_PLACER, pos, state);
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        if (this.redstonePower <= 0 && newPower > 0) {
            List powders = this.level.getEntitiesOfClass(EntityEffectInhibitor.class, new AABB(Vec3.atCenterOf((Vec3i)this.worldPosition), Vec3.atCenterOf((Vec3i)this.worldPosition.offset(1, 2, 1))), Entity::isAlive);
            block0: for (Direction facing : Direction.values()) {
                IItemHandler handler;
                BlockEntity tile;
                if (!facing.getAxis().isHorizontal() || (tile = this.level.getBlockEntity(this.worldPosition.relative(facing))) == null || (handler = (IItemHandler)this.level.getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, (Object)facing.getOpposite())) == null) continue;
                if (!powders.isEmpty()) {
                    block1: for (EntityEffectInhibitor powder : powders) {
                        ItemStack drop = powder.getDrop();
                        for (int i = 0; i < handler.getSlots(); ++i) {
                            ItemStack remain = handler.insertItem(i, drop, false);
                            if (remain.isEmpty()) {
                                powder.kill();
                                continue block1;
                            }
                            if (remain.getCount() == drop.getCount()) continue;
                            powder.setAmount(remain.getCount());
                        }
                    }
                    continue;
                }
                for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.extractItem(i, Integer.MAX_VALUE, true);
                    if (stack.isEmpty() || stack.getItem() != ModItems.EFFECT_POWDER) continue;
                    EntityEffectInhibitor.place(this.level, stack, (double)this.worldPosition.getX() + 0.5, this.worldPosition.getY() + 1, (double)this.worldPosition.getZ() + 0.5);
                    handler.extractItem(i, Integer.MAX_VALUE, false);
                    continue block0;
                }
            }
        }
        super.onRedstonePowerChange(newPower);
    }
}

