/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class BlockEntityRFConverter
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final RFStorage storage = new RFStorage();
    private int lastEnergy;

    public BlockEntityRFConverter(BlockPos pos, BlockState state) {
        super(ModBlockEntities.RF_CONVERTER, pos, state);
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        compound.putInt("energy", this.storage.getEnergyStored());
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        this.storage.setEnergy(compound.getInt("energy"));
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && ((Boolean)ModConfig.instance.rfConverter.get()).booleanValue()) {
            int emptyPart;
            if (this.lastEnergy != this.storage.getEnergyStored() && this.level.getGameTime() % 10L == 0L) {
                this.sendToClients();
                this.lastEnergy = this.storage.getEnergyStored();
            }
            for (Direction facing : Direction.values()) {
                int extracted;
                int canStore;
                IEnergyStorage storage;
                BlockEntity tile = this.level.getBlockEntity(this.worldPosition.relative(facing));
                if (tile == null || (storage = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, (Object)facing.getOpposite())) == null || (canStore = storage.receiveEnergy(Integer.MAX_VALUE, true)) <= 0 || (extracted = this.storage.extractEnergy(canStore, false)) <= 0) continue;
                storage.receiveEnergy(extracted, false);
                break;
            }
            if ((emptyPart = this.storage.getMaxEnergyStored() - this.storage.getEnergyStored()) <= 0) {
                return;
            }
            if (this.level.getGameTime() % 20L != 0L) {
                return;
            }
            if (!Multiblocks.RF_CONVERTER.isComplete(this.level, this.worldPosition)) {
                return;
            }
            int aura = IAuraChunk.getAuraInArea(this.level, this.worldPosition, 45);
            if (aura <= 1000000) {
                return;
            }
            int amountToGen = Math.min(Math.min(10000, aura / 1000), emptyPart);
            int amountToUse = Mth.ceil((double)((double)amountToGen / (Double)ModConfig.instance.auraToRFRatio.get()));
            this.storage.setEnergy(this.storage.getEnergyStored() + amountToGen);
            BlockPos pos = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 45, this.worldPosition);
            IAuraChunk.getAuraChunk(this.level, pos).drainAura(pos, amountToUse);
            PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.RF_CONVERTER, new int[0]));
        }
    }

    public void setRemoved() {
        super.setRemoved();
    }

    public static class RFStorage
    extends EnergyStorage {
        public RFStorage() {
            super(50000, 0, 2000);
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }
    }
}

