/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;

public class BlockEntitySnowCreator
extends BlockEntityImpl
implements ITickableBlockEntity {
    private int snowmanCount;

    public BlockEntitySnowCreator(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SNOW_CREATOR, pos, state);
    }

    public int getRange() {
        return this.redstonePower * 2;
    }

    @Override
    public void onRedstonePowerChange(int newPower) {
        super.onRedstonePowerChange(newPower);
        this.sendToClients();
    }

    @Override
    public void tick() {
        int range = this.getRange();
        if (range <= 0) {
            return;
        }
        int toDrain = 300;
        if (!this.canUseRightNow(toDrain)) {
            return;
        }
        if (!this.level.isClientSide) {
            if (this.level.getGameTime() % 10L != 0L) {
                return;
            }
            for (int i = 0; i < 10; ++i) {
                double angle = (double)this.level.random.nextFloat() * Math.PI * 2.0;
                BlockPos pos = this.worldPosition.offset(Mth.floor((double)(Math.cos(angle) * (double)range * (double)this.level.random.nextFloat())), 0, Mth.floor((double)(Math.sin(angle) * (double)range * (double)this.level.random.nextFloat())));
                BlockPos down = (pos = this.level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING, pos)).below();
                Fluid fluid = this.level.getFluidState(down).getType();
                if (fluid == Fluids.WATER) {
                    if (this.level.getBlockState(down).canBeReplaced()) {
                        this.level.setBlockAndUpdate(down, Blocks.ICE.defaultBlockState());
                    }
                } else {
                    if (!Blocks.SNOW.defaultBlockState().canSurvive((LevelReader)this.level, pos) || this.level.getBlockState(pos).getBlock() == Blocks.SNOW || !this.level.getBlockState(pos).canBeReplaced()) continue;
                    this.level.setBlockAndUpdate(pos, Blocks.SNOW.defaultBlockState());
                    if (this.snowmanCount < range / 2 && this.level.random.nextFloat() >= 0.995f) {
                        ++this.snowmanCount;
                        SnowGolem golem = new SnowGolem(EntityType.SNOW_GOLEM, this.level);
                        golem.setPos((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f));
                        this.level.addFreshEntity((Entity)golem);
                    }
                }
                BlockPos auraPos = IAuraChunk.getHighestSpot(this.level, this.worldPosition, 30, this.worldPosition);
                IAuraChunk.getAuraChunk(this.level, auraPos).drainAura(auraPos, toDrain);
                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), PacketParticles.Type.SNOW_CREATOR, new int[0]));
                break;
            }
        } else {
            if (this.level.getGameTime() % 30L != 0L) {
                return;
            }
            for (int i = range * 4; i >= 0; --i) {
                double angle = (double)this.level.random.nextFloat() * Math.PI * 2.0;
                BlockPos pos = this.worldPosition.offset(Mth.floor((double)(Math.cos(angle) * (double)range * (double)this.level.random.nextFloat())), Mth.nextInt((RandomSource)this.level.random, (int)(range / 2), (int)range), Mth.floor((double)(Math.sin(angle) * (double)range * (double)this.level.random.nextFloat())));
                NaturesAuraAPI.instance().spawnMagicParticle((float)pos.getX() + this.level.random.nextFloat(), pos.getY() + 1, (float)pos.getZ() + this.level.random.nextFloat(), this.level.random.nextGaussian() * 0.05, 0.0, this.level.random.nextGaussian() * 0.05, 14412287, 1.0f + this.level.random.nextFloat() * 1.5f, 10 * range, 0.05f + this.level.random.nextFloat() * 0.05f, true, true);
            }
        }
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            compound.putInt("snowman_count", this.snowmanCount);
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type == BlockEntityImpl.SaveType.TILE) {
            this.snowmanCount = compound.getInt("snowman_count");
        }
    }

    @Override
    public boolean allowsLowerLimiter() {
        return true;
    }
}

