/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import de.ellpeck.naturesaura.blocks.tiles.ITickableBlockEntity;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.blocks.tiles.ModBlockEntities;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class BlockEntityWoodStand
extends BlockEntityImpl
implements ITickableBlockEntity {
    public final ItemStackHandler items = new ItemStackHandlerNA(1, this, true){

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private RecipeHolder<TreeRitualRecipe> recipe;
    private BlockPos ritualPos;
    private int timer;

    public BlockEntityWoodStand(BlockPos pos, BlockState state) {
        super(ModBlockEntities.WOOD_STAND, pos, state);
    }

    public void setRitual(BlockPos pos, RecipeHolder<TreeRitualRecipe> recipe) {
        this.ritualPos = pos;
        this.recipe = recipe;
    }

    @Override
    public void tick() {
        if (!this.level.isClientSide && this.ritualPos != null && this.recipe != null && this.level.getGameTime() % 5L == 0L) {
            if (this.isRitualOkay()) {
                boolean isOverHalf;
                boolean wasOverHalf = this.timer >= ((TreeRitualRecipe)this.recipe.value()).time / 2;
                this.timer += 5;
                boolean bl = isOverHalf = this.timer >= ((TreeRitualRecipe)this.recipe.value()).time / 2;
                if (!isOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        BlockEntity tile = this.level.getBlockEntity(pos);
                        if (tile instanceof BlockEntityWoodStand && !((BlockEntityWoodStand)tile).items.getStackInSlot(0).isEmpty()) {
                            PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticleStream((float)pos.getX() + 0.2f + this.level.random.nextFloat() * 0.6f, (float)pos.getY() + 0.85f, (float)pos.getZ() + 0.2f + this.level.random.nextFloat() * 0.6f, (float)this.ritualPos.getX() + 0.5f, (float)this.ritualPos.getY() + this.level.random.nextFloat() * 3.0f + 2.0f, (float)this.ritualPos.getZ() + 0.5f, this.level.random.nextFloat() * 0.04f + 0.04f, 9030711, this.level.random.nextFloat() + 1.0f));
                        }
                        return true;
                    });
                }
                PacketHandler.sendToAllAround(this.level, this.ritualPos, 32, new PacketParticles(this.ritualPos.getX(), this.ritualPos.getY(), this.ritualPos.getZ(), PacketParticles.Type.TR_GOLD_POWDER, new int[0]));
                if (this.timer >= ((TreeRitualRecipe)this.recipe.value()).time) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'G', (pos, matcher) -> {
                        this.level.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
                        return true;
                    });
                    Helper.mineRecursively(this.level, this.ritualPos, this.ritualPos, ItemStack.EMPTY, 6, 32, s -> s.is(BlockTags.LOGS) || s.getBlock() instanceof LeavesBlock);
                    ItemEntity item = new ItemEntity(this.level, (double)this.ritualPos.getX() + 0.5, (double)this.ritualPos.getY() + 4.5, (double)this.ritualPos.getZ() + 0.5, ((TreeRitualRecipe)this.recipe.value()).output.copy());
                    this.level.addFreshEntity((Entity)item);
                    PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles((float)item.getX(), (float)item.getY(), (float)item.getZ(), PacketParticles.Type.TR_SPAWN_RESULT, new int[0]));
                    this.level.playSound(null, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, SoundEvents.ENDERMAN_TELEPORT, SoundSource.BLOCKS, 0.65f, 1.0f);
                    this.ritualPos = null;
                    this.recipe = null;
                    this.timer = 0;
                } else if (isOverHalf && !wasOverHalf) {
                    Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                        BlockEntity tile = this.level.getBlockEntity(pos);
                        if (tile instanceof BlockEntityWoodStand) {
                            BlockEntityWoodStand stand = (BlockEntityWoodStand)tile;
                            if (!stand.items.getStackInSlot(0).isEmpty()) {
                                PacketHandler.sendToAllAround(this.level, this.worldPosition, 32, new PacketParticles(stand.worldPosition.getX(), stand.worldPosition.getY(), stand.worldPosition.getZ(), PacketParticles.Type.TR_CONSUME_ITEM, new int[0]));
                                this.level.playSound(null, (double)stand.worldPosition.getX() + 0.5, (double)stand.worldPosition.getY() + 0.5, (double)stand.worldPosition.getZ() + 0.5, SoundEvents.WOOD_STEP, SoundSource.BLOCKS, 0.5f, 1.0f);
                                stand.items.setStackInSlot(0, ItemStack.EMPTY);
                                stand.sendToClients();
                            }
                        }
                        return true;
                    });
                }
            } else {
                this.ritualPos = null;
                this.recipe = null;
                this.timer = 0;
            }
        }
    }

    private boolean isRitualOkay() {
        if (!Multiblocks.TREE_RITUAL.isComplete(this.level, this.ritualPos)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            BlockState state = this.level.getBlockState(this.ritualPos.above(i));
            if (state.is(BlockTags.LOGS)) continue;
            return false;
        }
        if (this.timer < ((TreeRitualRecipe)this.recipe.value()).time / 2) {
            ArrayList<Ingredient> required = new ArrayList<Ingredient>(((TreeRitualRecipe)this.recipe.value()).ingredients);
            boolean fine = Multiblocks.TREE_RITUAL.forEach(this.ritualPos, 'W', (pos, matcher) -> {
                ItemStack stack;
                BlockEntity tile = this.level.getBlockEntity(pos);
                if (tile instanceof BlockEntityWoodStand && !(stack = ((BlockEntityWoodStand)tile).items.getStackInSlot(0)).isEmpty()) {
                    for (int i = required.size() - 1; i >= 0; --i) {
                        Ingredient req = (Ingredient)required.get(i);
                        if (!req.test(stack)) continue;
                        required.remove(i);
                        return true;
                    }
                    return false;
                }
                return true;
            });
            return fine && required.isEmpty();
        }
        return true;
    }

    @Override
    public void writeNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.writeNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            compound.put("items", (Tag)this.items.serializeNBT());
        }
        if (type == BlockEntityImpl.SaveType.TILE && this.ritualPos != null && this.recipe != null) {
            compound.putLong("ritual_pos", this.ritualPos.asLong());
            compound.putInt("timer", this.timer);
            compound.putString("recipe", this.recipe.toString());
        }
    }

    @Override
    public void readNBT(CompoundTag compound, BlockEntityImpl.SaveType type) {
        super.readNBT(compound, type);
        if (type != BlockEntityImpl.SaveType.BLOCK) {
            this.items.deserializeNBT(compound.getCompound("items"));
        }
        if (type == BlockEntityImpl.SaveType.TILE && compound.contains("recipe")) {
            this.ritualPos = BlockPos.of((long)compound.getLong("ritual_pos"));
            this.timer = compound.getInt("timer");
            if (this.hasLevel()) {
                this.recipe = this.level.getRecipeManager().byKey(new ResourceLocation(compound.getString("recipe"))).orElse(null);
            }
        }
    }
}

