/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAuraTimer;
import de.ellpeck.naturesaura.items.ItemAuraBottle;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;

public class RenderAuraTimer
implements BlockEntityRenderer<BlockEntityAuraTimer> {
    private static final ResourceLocation RES = new ResourceLocation("naturesaura", "textures/models/aura_timer_aura.png");
    private final AuraModel model = new AuraModel();

    public RenderAuraTimer(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityAuraTimer tile, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        ItemStack bottle = ((IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), (BlockEntity)tile, null)).getStackInSlot(0);
        if (bottle.isEmpty()) {
            return;
        }
        stack.pushPose();
        stack.translate(0.25f, 0.1250625f, 0.25f);
        float percentage = 1.0f - tile.getTimerPercentage();
        stack.scale(0.5f, 0.40625f * percentage, 0.5f);
        IAuraType type = ItemAuraBottle.getType(bottle);
        float r = (float)(type.getColor() >> 16 & 0xFF) / 255.0f;
        float g = (float)(type.getColor() >> 8 & 0xFF) / 255.0f;
        float b = (float)(type.getColor() & 0xFF) / 255.0f;
        this.model.renderToBuffer(stack, buffer.getBuffer(this.model.renderType(RES)), combinedLightIn, combinedOverlayIn, r, g, b, 0.75f);
        stack.popPose();
    }

    private static class AuraModel
    extends Model {
        private final ModelPart model;

        public AuraModel() {
            super(RenderType::entityTranslucent);
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition part = mesh.getRoot();
            part.addOrReplaceChild("main", new CubeListBuilder().addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
            this.model = LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64).bakeRoot();
        }

        public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.model.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

