/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGeneratorLimitRemover;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityImpl;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderGeneratorLimitRemover
implements BlockEntityRenderer<BlockEntityGeneratorLimitRemover> {
    private static final ResourceLocation RES = new ResourceLocation("naturesaura", "textures/models/generator_limit_remover_glint.png");
    private final ModelLimitRemoverGlint model = new ModelLimitRemoverGlint();

    public RenderGeneratorLimitRemover(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityGeneratorLimitRemover te, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        BlockEntity above = te.getLevel().getBlockEntity(te.getBlockPos().above());
        if (above instanceof BlockEntityImpl && ((BlockEntityImpl)above).wantsLimitRemover()) {
            RenderGeneratorLimitRemover.renderGlint(matrixStack, iRenderTypeBuffer, this.model, 0, 1, 0, combinedOverlayIn, RES, 1.0f);
            RenderGeneratorLimitRemover.renderGlint(matrixStack, iRenderTypeBuffer, this.model, 0, 0, 0, combinedOverlayIn, RES, 1.0f);
        }
    }

    public static void renderGlint(PoseStack stack, MultiBufferSource buffer, ModelLimitRemoverGlint model, int xOff, int yOff, int zOff, int combinedOverlayIn, ResourceLocation texture, float maxAlpha) {
        stack.pushPose();
        int brightness = 0xF000F0;
        float alpha = ((float)Math.sin((double)System.currentTimeMillis() / 800.0) + 1.0f) / 2.0f;
        stack.translate(-0.002f + (float)xOff, 1.002f + (float)yOff, 1.002f + (float)zOff);
        stack.mulPose(Axis.XP.rotationDegrees(180.0f));
        stack.scale(1.004f, 1.004f, 1.004f);
        model.renderToBuffer(stack, buffer.getBuffer(model.renderType(texture)), brightness, combinedOverlayIn, 1.0f, 1.0f, 1.0f, alpha * maxAlpha);
        stack.popPose();
    }

    public static class ModelLimitRemoverGlint
    extends Model {
        private final ModelPart model;

        public ModelLimitRemoverGlint() {
            super(RenderType::entityTranslucent);
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition part = mesh.getRoot();
            part.addOrReplaceChild("main", new CubeListBuilder().addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
            this.model = LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64).bakeRoot();
        }

        public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.model.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

