/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityOfferingTable;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.util.Mth;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderOfferingTable
implements BlockEntityRenderer<BlockEntityOfferingTable> {
    private final Random rand = new Random();

    public RenderOfferingTable(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityOfferingTable tileEntityOfferingTable, float v, PoseStack matrixStack, MultiBufferSource iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        ItemStack stack = tileEntityOfferingTable.items.getStackInSlot(0);
        if (!stack.isEmpty()) {
            this.rand.setSeed(Item.getId((Item)stack.getItem()) + stack.getDamageValue());
            int amount = Mth.ceil((float)((float)stack.getCount() / 2.0f));
            for (int i = 0; i < amount; ++i) {
                float yOff;
                float scale;
                matrixStack.pushPose();
                Item item = stack.getItem();
                if (item instanceof BlockItem) {
                    scale = 0.5f;
                    yOff = 0.08f;
                } else {
                    scale = 0.35f;
                    yOff = 0.0f;
                }
                matrixStack.translate(0.35f + this.rand.nextFloat() * 0.3f, 0.9f + yOff + (float)i * 0.001f, 0.35f + this.rand.nextFloat() * 0.3f);
                matrixStack.mulPose(Axis.YP.rotationDegrees(this.rand.nextFloat() * 360.0f));
                matrixStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                matrixStack.scale(scale, scale, scale);
                Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, combinedLightIn, combinedOverlayIn, matrixStack, iRenderTypeBuffer, tileEntityOfferingTable.getLevel(), 0);
                matrixStack.popPose();
            }
        }
    }
}

