/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.blocks.tiles.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityProjectileGenerator;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class RenderProjectileGenerator
implements BlockEntityRenderer<BlockEntityProjectileGenerator> {
    private static final ResourceLocation RES = new ResourceLocation("naturesaura", "textures/models/projectile_generator_overlay.png");
    private final ModelOverlay model = new ModelOverlay();

    public RenderProjectileGenerator(BlockEntityRendererProvider.Context context) {
    }

    public void render(BlockEntityProjectileGenerator te, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        stack.pushPose();
        if (te.nextSide == Direction.NORTH) {
            stack.mulPose(Axis.YP.rotationDegrees(270.0f));
            stack.translate(-0.002f, 0.0f, -1.0f);
        } else if (te.nextSide == Direction.EAST) {
            stack.mulPose(Axis.YP.rotationDegrees(180.0f));
            stack.translate(-1.002f, 0.0f, -1.0f);
        } else if (te.nextSide == Direction.SOUTH) {
            stack.mulPose(Axis.YP.rotationDegrees(90.0f));
            stack.translate(-1.002f, 0.0f, 0.0f);
        } else {
            stack.translate(-0.002f, 0.0f, 0.0f);
        }
        int brightness = 0xF000F0;
        this.model.renderToBuffer(stack, buffer.getBuffer(this.model.renderType(RES)), brightness, combinedOverlayIn, 1.0f, 1.0f, 1.0f, 1.0f);
        stack.popPose();
    }

    private static class ModelOverlay
    extends Model {
        private final ModelPart model;

        public ModelOverlay() {
            super(RenderType::entityTranslucent);
            MeshDefinition mesh = new MeshDefinition();
            PartDefinition part = mesh.getRoot();
            part.addOrReplaceChild("main", new CubeListBuilder().addBox(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.ZERO);
            this.model = LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)64).bakeRoot();
        }

        public void renderToBuffer(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
            this.model.render(matrixStackIn, bufferIn, packedLightIn, packedOverlayIn, red, green, blue, alpha);
        }
    }
}

