/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.event.EventHooks;

public class ExplosionEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "explosions");
    private float strength;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot >= 0) {
            return false;
        }
        int aura = IAuraChunk.getAuraInArea(level, pos, 85);
        if (aura > -5000000) {
            return false;
        }
        int chance = 140 - Math.abs(aura) / 200000;
        if (chance > 1 && level.random.nextInt(chance) != 0) {
            return false;
        }
        this.strength = Math.min((float)Math.abs(aura) / 5000000.0f, 5.0f);
        if (this.strength <= 0.0f) {
            return false;
        }
        this.dist = Mth.clamp((int)(Math.abs(aura) / 200000), (int)25, (int)100);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.level(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Blocks.TNT);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        Explosion explosion;
        int z;
        if (level.getGameTime() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        int x = Mth.floor((double)((double)pos.getX() + level.random.nextGaussian() * (double)this.dist));
        BlockPos chosenPos = new BlockPos(x, level.getHeight(Heightmap.Types.WORLD_SURFACE, x, z = Mth.floor((double)((double)pos.getZ() + level.random.nextGaussian() * (double)this.dist))), z);
        if (chosenPos.distSqr((Vec3i)pos) <= (double)(this.dist * this.dist) && level.isLoaded(chosenPos) && !EventHooks.onExplosionStart((Level)level, (Explosion)(explosion = new Explosion(level, null, (double)chosenPos.getX() + 0.5, (double)chosenPos.getY() + 0.5, (double)chosenPos.getZ() + 0.5, this.strength, false, Explosion.BlockInteraction.DESTROY)))) {
            explosion.explode();
            explosion.finalizeExplosion(true);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.explosionEffect.get();
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

