/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.commons.lang3.tuple.Pair;

public class GrassDieEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "grass_die");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        Pair<Integer, Integer> auraAndSpots;
        int aura;
        if (spot < 0 && (aura = ((Integer)(auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 50)).getLeft()).intValue()) < 0) {
            this.amount = Math.min(300, Mth.ceil((float)((float)Math.abs(aura) / 100000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
            if (this.amount > 1) {
                this.dist = Mth.clamp((int)(Math.abs(aura) / 75000), (int)5, (int)75);
                return true;
            }
        }
        return false;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.level(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)ModBlocks.DECAYED_LEAVES);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        for (int i = this.amount / 2 + level.random.nextInt(this.amount / 2); i >= 0; --i) {
            BlockPos grassPos = BlockPos.containing((double)((double)pos.getX() + level.random.nextGaussian() * (double)this.dist), (double)((double)pos.getY() + level.random.nextGaussian() * (double)this.dist), (double)((double)pos.getZ() + level.random.nextGaussian() * (double)this.dist));
            if (!(grassPos.distSqr((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.isLoaded(grassPos)) continue;
            BlockState state = level.getBlockState(grassPos);
            Block block = state.getBlock();
            BlockState newState = null;
            if (block instanceof LeavesBlock) {
                newState = ModBlocks.DECAYED_LEAVES.defaultBlockState();
            } else if (block instanceof GrassBlock) {
                newState = Blocks.COARSE_DIRT.defaultBlockState();
            } else if (block instanceof BushBlock) {
                newState = Blocks.AIR.defaultBlockState();
            } else if (block == ModBlocks.NETHER_GRASS) {
                newState = Blocks.NETHERRACK.defaultBlockState();
            }
            if (newState == null) continue;
            level.setBlockAndUpdate(grassPos, newState);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.grassDieEffect.get() != false && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

