/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.packet.PacketHandler;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.common.Tags;
import org.apache.commons.lang3.tuple.Pair;

public class NetherGrassEffect
implements IDrainSpotEffect {
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "nether_grass");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura < 1500000) {
            return false;
        }
        this.amount = Math.min(20, Mth.ceil((float)((float)Math.abs(aura) / 100000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 1) {
            return false;
        }
        this.dist = Mth.clamp((int)(Math.abs(aura) / 100000), (int)5, (int)35);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.level(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (NaturesAuraAPI.instance().isEffectPowderActive(player.level(), player.blockPosition(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)ModBlocks.NETHER_GRASS);
    }

    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (level.getGameTime() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        block0: for (int i = this.amount / 2 + level.random.nextInt(this.amount / 2); i >= 0; --i) {
            int x = Mth.floor((double)((double)pos.getX() + level.random.nextGaussian() * (double)this.dist));
            int y = Mth.floor((double)((double)pos.getY() + level.random.nextGaussian() * (double)this.dist));
            int z = Mth.floor((double)((double)pos.getZ() + level.random.nextGaussian() * (double)this.dist));
            for (int yOff = -5; yOff <= 5; ++yOff) {
                BlockState state;
                BlockPos up;
                BlockPos goalPos = new BlockPos(x, y + yOff, z);
                if (!(goalPos.distSqr((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.isLoaded(goalPos) || NaturesAuraAPI.instance().isEffectPowderActive(level, goalPos, NAME) || level.getBlockState(up = goalPos.above()).isFaceSturdy((BlockGetter)level, up, Direction.DOWN) || !(state = level.getBlockState(goalPos)).is(Tags.Blocks.NETHERRACK)) continue;
                level.setBlockAndUpdate(goalPos, ModBlocks.NETHER_GRASS.defaultBlockState());
                BlockPos closestSpot = IAuraChunk.getHighestSpot(level, goalPos, 25, pos);
                IAuraChunk.getAuraChunk(level, closestSpot).drainAura(closestSpot, 500);
                PacketHandler.sendToAllAround(level, goalPos, 32, new PacketParticles(goalPos.getX(), (float)goalPos.getY() + 0.5f, goalPos.getZ(), PacketParticles.Type.PLANT_BOOST, new int[0]));
                continue block0;
            }
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.netherGrassEffect.get() != false && type.isSimilar(NaturesAuraAPI.TYPE_NETHER);
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

